/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing.internal;

import io.quarkiverse.githubapp.error.ErrorHandler;
import io.quarkiverse.githubapp.runtime.github.GitHubFileDownloader;
import io.quarkiverse.githubapp.runtime.github.GitHubService;
import io.quarkiverse.githubapp.testing.internal.GitHubAppTestingContext;
import io.quarkiverse.githubapp.testing.internal.GitHubMockContextImpl;
import io.quarkus.test.junit.QuarkusMock;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

public final class GitHubAppTestingCallback
implements QuarkusTestAfterConstructCallback {
    private static final String ENABLED_KEY = "quarkiverse-github-app-testing.enabled";

    public static void enable(Map<String, String> configProperties) {
        configProperties.put(ENABLED_KEY, "true");
    }

    static boolean isEnabled() {
        return (Boolean)ConfigProviderResolver.instance().getConfig().getValue(ENABLED_KEY, Boolean.class);
    }

    public void afterConstruct(Object testInstance) {
        if (!GitHubAppTestingCallback.isEnabled()) {
            GitHubAppTestingContext.reset();
            return;
        }
        GitHubAppTestingContext.set(testInstance);
        GitHubAppTestingContext context = GitHubAppTestingContext.get();
        GitHubMockContextImpl mocks = context.mocks;
        QuarkusMock.installMockForType((Object)mocks.service, GitHubService.class, (Annotation[])new Annotation[0]);
        QuarkusMock.installMockForType((Object)mocks.fileDownloader, GitHubFileDownloader.class, (Annotation[])new Annotation[0]);
        QuarkusMock.installMockForType((Object)((Object)context.errorHandler), ErrorHandler.class, (Annotation[])new Annotation[0]);
    }
}

