/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing.mockito.internal;

import io.quarkiverse.githubapp.testing.internal.MockitoUtils;
import io.quarkiverse.githubapp.testing.mockito.internal.DefaultableMocking;
import io.quarkiverse.githubapp.testing.mockito.internal.GHObjectSpyDefaultAnswer;
import java.io.Serializable;
import java.util.function.Function;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GitHub;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public final class GHEventPayloadSpyDefaultAnswer
implements Answer<Object>,
Serializable {
    private final GitHub clientSpy;
    private final Function<GHObject, DefaultableMocking<? extends GHObject>> defaultableMockingProvider;

    public GHEventPayloadSpyDefaultAnswer(GitHub clientSpy, Function<GHObject, DefaultableMocking<? extends GHObject>> defaultableMockingProvider) {
        this.clientSpy = clientSpy;
        this.defaultableMockingProvider = defaultableMockingProvider;
    }

    public Object answer(InvocationOnMock invocation) throws Throwable {
        Object original = invocation.callRealMethod();
        if (!(original instanceof GHObject)) {
            return original;
        }
        GHObject castOriginal = (GHObject)original;
        Class<?> type = castOriginal.getClass();
        return MockitoUtils.doWithMockedClassClassLoader(type, () -> {
            DefaultableMocking<? extends GHObject> mocking = this.defaultableMockingProvider.apply(castOriginal);
            return (GHObject)Mockito.mock((Class)type, (MockSettings)Mockito.withSettings().stubOnly().withoutAnnotations().spiedInstance(original).defaultAnswer((Answer)new GHObjectSpyDefaultAnswer(this.clientSpy, this, mocking)));
        });
    }
}

