/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing.mockito.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.function.Consumer;
import org.mockito.Answers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.invocation.DefaultInvocationFactory;
import org.mockito.internal.invocation.InterceptedInvocation;
import org.mockito.internal.invocation.RealMethod;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.invocation.Location;
import org.mockito.invocation.MockHandler;
import org.mockito.listeners.InvocationListener;
import org.mockito.listeners.MethodInvocationReport;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public final class DefaultableMocking<M> {
    private static final MockMaker mockMaker = Plugins.getMockMaker();
    private final M mock;
    private final StubDetectingInvocationListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <M> DefaultableMocking<M> create(Class<M> clazz, Object id, Consumer<MockSettings> mockSettingsContributor, Answers defaultAnswer) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
            StubDetectingInvocationListener listener = new StubDetectingInvocationListener();
            MockSettings mockSettings = Mockito.withSettings().name(clazz.getSimpleName() + "#" + id).withoutAnnotations().defaultAnswer((Answer)defaultAnswer).invocationListeners(new InvocationListener[]{listener});
            mockSettingsContributor.accept(mockSettings);
            Object mock = Mockito.mock(clazz, (MockSettings)mockSettings);
            DefaultableMocking<Object> defaultableMocking = new DefaultableMocking<Object>(mock, listener);
            return defaultableMocking;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private DefaultableMocking(M mock, StubDetectingInvocationListener listener) {
        this.mock = mock;
        this.listener = listener;
    }

    public M mock() {
        return this.mock;
    }

    Object callMock(final InvocationOnMock invocationOnMockProxy) throws Throwable {
        Object[] argumentsForJava = DefaultableMocking.unexpandArguments(invocationOnMockProxy);
        MockHandler handler = mockMaker.getHandler(this.mock);
        InterceptedInvocation invocationOnMock = DefaultInvocationFactory.createInvocation(this.mock, (Method)invocationOnMockProxy.getMethod(), (Object[])argumentsForJava, (RealMethod)new RealMethod(){

            public boolean isInvokable() {
                return true;
            }

            public Object invoke() throws Throwable {
                return invocationOnMockProxy.callRealMethod();
            }
        }, (MockCreationSettings)handler.getMockSettings(), (Location)((Invocation)invocationOnMockProxy).getLocation());
        return handler.handle((Invocation)invocationOnMock);
    }

    Object callMockOrDefault(InvocationOnMock invocationOnMockProxy, Answer<?> defaultAnswer) throws Throwable {
        Object result = this.callMock(invocationOnMockProxy);
        if (this.listener.lastInvocationWasMocked) {
            return result;
        }
        DefaultableMocking.call(Mockito.verify(this.mock, (VerificationMode)Mockito.atLeastOnce()), invocationOnMockProxy);
        return defaultAnswer.answer(invocationOnMockProxy);
    }

    private static Object call(Object self, InvocationOnMock invocation) throws Throwable {
        Object[] argumentsForJava = DefaultableMocking.unexpandArguments(invocation);
        return invocation.getMethod().invoke(self, argumentsForJava);
    }

    private static Object[] unexpandArguments(InvocationOnMock invocation) {
        Method method = invocation.getMethod();
        Parameter[] parameters = method.getParameters();
        Object[] unexpandedArguments = new Object[parameters.length];
        Object[] argumentsWithExpandedVarArgs = invocation.getArguments();
        for (int i = 0; i < unexpandedArguments.length; ++i) {
            if (parameters[i].isVarArgs()) {
                int varArgSize = argumentsWithExpandedVarArgs.length - parameters.length + 1;
                Object varArgs = Array.newInstance(parameters[i].getType().getComponentType(), varArgSize);
                if (varArgSize > 0) {
                    System.arraycopy(argumentsWithExpandedVarArgs, i, varArgs, 0, varArgSize);
                }
                unexpandedArguments[i] = varArgs;
                continue;
            }
            unexpandedArguments[i] = argumentsWithExpandedVarArgs[i];
        }
        return unexpandedArguments;
    }

    private static class StubDetectingInvocationListener
    implements InvocationListener {
        private boolean lastInvocationWasMocked = false;

        private StubDetectingInvocationListener() {
        }

        public void reportInvocation(MethodInvocationReport methodInvocationReport) {
            this.lastInvocationWasMocked = methodInvocationReport.getLocationOfStubbing() != null;
        }
    }
}

