/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing.internal;

import io.quarkiverse.githubapp.runtime.Routes;
import io.quarkiverse.githubapp.testing.dsl.EventSenderOptions;
import io.quarkiverse.githubapp.testing.internal.EventHandlingResponseImpl;
import io.quarkiverse.githubapp.testing.internal.GitHubAppTestingContext;
import io.quarkus.arc.Arc;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import org.eclipse.microprofile.config.ConfigProvider;
import org.kohsuke.github.GHEvent;

final class EventSenderOptionsImpl
implements EventSenderOptions {
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private final GitHubAppTestingContext testingContext;
    private final HttpClient httpClient;
    private UUID requestId;
    private UUID deliveryId;
    private long installationId;
    private String payload;
    private String contentType;

    EventSenderOptionsImpl(GitHubAppTestingContext testingContext) {
        this.testingContext = testingContext;
        Duration forever = Duration.ofDays(1L);
        this.httpClient = HttpClient.newBuilder().connectTimeout(forever).build();
    }

    @Override
    public EventSenderOptions requestId(UUID requestId) {
        this.requestId = requestId;
        return this;
    }

    @Override
    public EventSenderOptions deliveryId(UUID deliveryId) {
        this.deliveryId = deliveryId;
        return this;
    }

    @Override
    public EventSenderOptions payloadFromString(String payload) {
        return this.payloadFromString(payload, DEFAULT_CONTENT_TYPE);
    }

    @Override
    public EventSenderOptions payloadFromString(String payload, String contentType) {
        this.payload = payload;
        this.contentType = contentType;
        JsonObject payloadAsJsonObject = new JsonObject(payload);
        this.installationId = ((Routes)Arc.container().instance(Routes.class, new Annotation[0]).get()).extractInstallationId(payloadAsJsonObject);
        return this;
    }

    @Override
    public EventSenderOptions payloadFromClasspath(String path) throws IOException {
        return this.payloadFromClasspath(path, DEFAULT_CONTENT_TYPE);
    }

    @Override
    public EventSenderOptions payloadFromClasspath(String path, String contentType) throws IOException {
        return this.payloadFromString(this.testingContext.getFromClasspath(path), contentType);
    }

    @Override
    public EventHandlingResponseImpl event(GHEvent event) {
        return this.event(event, false);
    }

    @Override
    public EventHandlingResponseImpl event(GHEvent event, boolean ignoreExceptions) {
        HttpRequest request = HttpRequest.newBuilder(this.buildUrl()).POST(HttpRequest.BodyPublishers.ofString(this.payload)).header("Content-Type", this.contentType).header("X-Request-ID", (this.requestId == null ? UUID.randomUUID() : this.requestId).toString()).header("X-GitHub-Delivery", (this.deliveryId == null ? UUID.randomUUID() : this.deliveryId).toString()).header("X-GitHub-Event", this.symbol(event)).build();
        this.testingContext.mocks.initEventStubs(this.installationId);
        this.testingContext.errorHandler.captured = null;
        AssertionError callAssertionError = null;
        try {
            this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
        }
        catch (Throwable e) {
            callAssertionError = new AssertionError("The HTTP call threw an exception: " + e.getMessage(), e);
        }
        Object handlingAssertionError = null;
        if (this.testingContext.errorHandler.captured != null) {
            Throwable unwrappedCaptured = EventSenderOptionsImpl.unwrapCompletionException(this.testingContext.errorHandler.captured);
            handlingAssertionError = new AssertionError("The event handler threw an exception: " + unwrappedCaptured.getMessage(), unwrappedCaptured);
        }
        if (handlingAssertionError != null) {
            if (callAssertionError != null) {
                ((Throwable)handlingAssertionError).addSuppressed((Throwable)((Object)callAssertionError));
            }
            if (!ignoreExceptions) {
                throw handlingAssertionError;
            }
        } else if (callAssertionError != null) {
            throw callAssertionError;
        }
        return new EventHandlingResponseImpl(this.testingContext);
    }

    private static Throwable unwrapCompletionException(Throwable captured) {
        if (captured instanceof CompletionException && captured.getCause() != null) {
            return captured.getCause();
        }
        return captured;
    }

    private URI buildUrl() {
        int port = ConfigProvider.getConfig().getOptionalValue("quarkus.http.test-port", Integer.class).orElse(8081);
        String path = "/";
        return URI.create("http://localhost:" + port + path);
    }

    private String symbol(GHEvent event) {
        if (event == GHEvent.ALL) {
            return "*";
        }
        return event.name().toLowerCase(Locale.ENGLISH);
    }
}

