/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing.mockito.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.kohsuke.github.GHRepository;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public final class GitHubMockDefaultAnswer
implements Answer<Object>,
Serializable {
    private final Answer<Object> delegate;
    private final Function<String, GHRepository> repositoryMockProvider;

    public GitHubMockDefaultAnswer(Answer<Object> delegate, Function<String, GHRepository> repositoryMockProvider) {
        this.delegate = delegate;
        this.repositoryMockProvider = repositoryMockProvider;
    }

    public Object answer(InvocationOnMock invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (method.getParameterCount() == 1) {
            switch (method.getName()) {
                case "intern": {
                    return invocation.callRealMethod();
                }
                case "isOffline": {
                    return true;
                }
                case "getRepository": {
                    return this.repositoryMockProvider.apply((String)invocation.getArgument(0, String.class));
                }
            }
        }
        return this.delegate.answer(invocation);
    }
}

