/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing;

import java.util.Iterator;
import java.util.List;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.PagedSearchIterable;
import org.mockito.Answers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Answer;

public final class GitHubAppMockito {
    private GitHubAppMockito() {
    }

    public static <T> T mockBuilder(Class<T> builderClass) {
        return (T)Mockito.mock(builderClass, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.RETURNS_SELF));
    }

    @SafeVarargs
    public static <T> PagedSearchIterable<T> mockPagedIterable(T ... contentMocks) {
        PagedSearchIterable iterableMock = (PagedSearchIterable)Mockito.mock(PagedSearchIterable.class, (MockSettings)Mockito.withSettings().stubOnly().strictness(Strictness.LENIENT).defaultAnswer((Answer)Answers.RETURNS_SELF));
        Mockito.when((Object)iterableMock.spliterator()).thenAnswer(ignored -> List.of(contentMocks).spliterator());
        Mockito.when((Object)iterableMock.iterator()).thenAnswer(ignored -> {
            PagedIterator iteratorMock = (PagedIterator)Mockito.mock(PagedIterator.class, (MockSettings)Mockito.withSettings().stubOnly().strictness(Strictness.LENIENT));
            Iterator<Object> actualIterator = List.of(contentMocks).iterator();
            Mockito.when((Object)iteratorMock.next()).thenAnswer(ignored2 -> actualIterator.next());
            Mockito.when((Object)iteratorMock.hasNext()).thenAnswer(ignored2 -> actualIterator.hasNext());
            return iteratorMock;
        });
        return iterableMock;
    }
}

