/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.config;

import io.quarkiverse.githubapp.runtime.signing.PrivateKeyUtil;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=200)
public class PrivateKeyConverter
implements Converter<PrivateKey>,
Serializable {
    public PrivateKey convert(String value) {
        String privateKeyValue = value.trim();
        if (privateKeyValue.isEmpty()) {
            return null;
        }
        try {
            return PrivateKeyUtil.loadKey(privateKeyValue);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationException("Unable to interpret the provided private key", (Throwable)e);
        }
    }
}

