/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.signing;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public class PrivateKeyUtil {
    private static final String PKCS_1_PEM_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String PKCS_1_PEM_FOOTER = "-----END RSA PRIVATE KEY-----";
    private static final String PKCS_8_PEM_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String PKCS_8_PEM_FOOTER = "-----END PRIVATE KEY-----";

    public static PrivateKey loadKey(String keyDataString) throws GeneralSecurityException {
        if (keyDataString.contains(PKCS_1_PEM_HEADER)) {
            keyDataString = keyDataString.replace(PKCS_1_PEM_HEADER, "");
            keyDataString = keyDataString.replace(PKCS_1_PEM_FOOTER, "");
            keyDataString = keyDataString.replaceAll("\\s+", "");
            return PrivateKeyUtil.readPkcs1PrivateKey(Base64.getDecoder().decode(keyDataString));
        }
        if (keyDataString.contains(PKCS_8_PEM_HEADER)) {
            keyDataString = keyDataString.replace(PKCS_8_PEM_HEADER, "");
            keyDataString = keyDataString.replace(PKCS_8_PEM_FOOTER, "");
            keyDataString = keyDataString.replaceAll("\\s+", "");
            return PrivateKeyUtil.readPkcs8PrivateKey(Base64.getDecoder().decode(keyDataString));
        }
        throw new IllegalArgumentException("Private key format not supported");
    }

    private static PrivateKey readPkcs8PrivateKey(byte[] pkcs8Bytes) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SunRsaSign");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8Bytes);
        try {
            return keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Unexpected key format", e);
        }
    }

    private static PrivateKey readPkcs1PrivateKey(byte[] pkcs1Bytes) throws GeneralSecurityException {
        int pkcs1Length = pkcs1Bytes.length;
        int totalLength = pkcs1Length + 22;
        byte[] pkcs8Header = new byte[]{48, -126, (byte)(totalLength >> 8 & 0xFF), (byte)(totalLength & 0xFF), 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, (byte)(pkcs1Length >> 8 & 0xFF), (byte)(pkcs1Length & 0xFF)};
        byte[] pkcs8bytes = PrivateKeyUtil.join(pkcs8Header, pkcs1Bytes);
        return PrivateKeyUtil.readPkcs8PrivateKey(pkcs8bytes);
    }

    private static byte[] join(byte[] byteArray1, byte[] byteArray2) {
        byte[] bytes = new byte[byteArray1.length + byteArray2.length];
        System.arraycopy(byteArray1, 0, bytes, 0, byteArray1.length);
        System.arraycopy(byteArray2, 0, bytes, byteArray1.length, byteArray2.length);
        return bytes;
    }
}

