/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.signing;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Date;
import javax.inject.Singleton;

@Singleton
public class JwtTokenCreator {
    public String createJwtToken(String githubAppId, PrivateKey privateKey, long ttlMillis) throws GeneralSecurityException, IOException {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        JwtBuilder builder = Jwts.builder().setIssuedAt(now).setIssuer(githubAppId).signWith((Key)privateKey, signatureAlgorithm);
        if (ttlMillis > 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }
}

