/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime;

import io.quarkiverse.githubapp.ConfigFile;
import io.quarkiverse.githubapp.GitHubConfigFileProvider;
import io.quarkiverse.githubapp.runtime.config.CheckedConfigProvider;
import io.quarkiverse.githubapp.runtime.github.GitHubConfigFileProviderImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.kohsuke.github.GHRepository;

@RequestScoped
public class RequestScopeCachingGitHubConfigFileProvider {
    @Inject
    CheckedConfigProvider checkedConfigProvider;
    @Inject
    GitHubConfigFileProvider gitHubConfigFileProvider;
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

    public Object getConfigObject(GHRepository ghRepository, String path, ConfigFile.Source source, Class<?> type) {
        String cacheKey = this.getCacheKey(ghRepository, path, source);
        Object cachedObject = this.cache.get(cacheKey);
        if (cachedObject != null) {
            return cachedObject;
        }
        return this.cache.computeIfAbsent(cacheKey, k -> this.gitHubConfigFileProvider.fetchConfigFile(ghRepository, path, source, type).orElse(null));
    }

    private String getCacheKey(GHRepository ghRepository, String path, ConfigFile.Source source) {
        String fullPath = GitHubConfigFileProviderImpl.getFilePath(path.trim());
        ConfigFile.Source effectiveSource = this.checkedConfigProvider.getEffectiveSource(source);
        return ghRepository.getFullName() + ":" + effectiveSource.name() + ":" + fullPath;
    }
}

