/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.replay;

import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.runtime.replay.ReplayEvent;
import io.quarkus.arc.profile.IfBuildProfile;
import io.quarkus.vertx.web.Route;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@IfBuildProfile(value="dev")
public class ReplayEventsRoute {
    private final ConcurrentLinkedQueue<ReplayEvent> recordedEvents = new ConcurrentLinkedQueue();
    private final BroadcastProcessor<ReplayEvent> broadcastProcessor = BroadcastProcessor.create();

    @Route(path="/replay/events", produces={"text/event-stream"})
    Multi<ReplayEvent> replayEvents(RoutingContext context) {
        return Multi.createBy().merging().streams(new Publisher[]{Multi.createFrom().iterable(this.recordedEvents), this.broadcastProcessor.onOverflow().drop(), Multi.createFrom().ticks().every(Duration.ofMillis(100L)).onOverflow().drop().map(x -> ReplayEvent.PING)});
    }

    public void pushEvent(GitHubEvent gitHubEvent) {
        ReplayEvent replayEvent = new ReplayEvent(gitHubEvent);
        this.recordedEvents.add(replayEvent);
        this.broadcastProcessor.onNext((Object)replayEvent);
    }
}

