/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.signing;

import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.build.JwtClaimsBuilder;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

@Singleton
public class JwtTokenCreator {
    public String createJwtToken(String githubAppId, PrivateKey privateKey, long ttlSeconds) throws GeneralSecurityException, IOException {
        JwtClaimsBuilder jwtClaimsBuilder = Jwt.issuer((String)githubAppId);
        if (ttlSeconds > 0L) {
            jwtClaimsBuilder.expiresIn(ttlSeconds);
        }
        return jwtClaimsBuilder.sign(privateKey);
    }
}

