/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.vertx.core.json.JsonObject;
import java.util.Optional;

public class GitHubEvent {
    private final Long installationId;
    private final Optional<String> appName;
    private final String deliveryId;
    private final Optional<String> repository;
    private final String event;
    private final String action;
    private final String eventAction;
    private final String payload;
    private final JsonObject parsedPayload;
    private final boolean replayed;

    public GitHubEvent(Long installationId, String appName, String deliveryId, String repository, String event, String action, String payload, JsonObject parsedPayload, boolean replayed) {
        this.installationId = installationId;
        this.appName = Optional.ofNullable(appName);
        this.deliveryId = deliveryId;
        this.repository = Optional.ofNullable(repository);
        this.event = event;
        this.action = action;
        this.payload = payload;
        this.parsedPayload = parsedPayload;
        this.replayed = replayed;
        StringBuilder eventActionSb = new StringBuilder();
        if (event != null && !event.isBlank()) {
            eventActionSb.append(event);
        }
        if (action != null && !action.isBlank()) {
            eventActionSb.append(".").append(action);
        }
        this.eventAction = eventActionSb.toString();
    }

    public Long getInstallationId() {
        return this.installationId;
    }

    public Optional<String> getAppName() {
        return this.appName;
    }

    public String getDeliveryId() {
        return this.deliveryId;
    }

    public Optional<String> getRepository() {
        return this.repository;
    }

    @JsonIgnore
    public String getRepositoryOrThrow() {
        return this.repository.orElseThrow(() -> new IllegalStateException("The payload did not provide any repository information"));
    }

    public String getEvent() {
        return this.event;
    }

    public String getAction() {
        return this.action;
    }

    public String getEventAction() {
        return this.eventAction;
    }

    public String getPayload() {
        return this.payload;
    }

    @JsonIgnore
    public JsonObject getParsedPayload() {
        if (this.parsedPayload == null) {
            throw new IllegalStateException("getParsedPayload() may not be called on GitHubEvents that have been serialized");
        }
        return this.parsedPayload;
    }

    public boolean isReplayed() {
        return this.replayed;
    }

    public String toString() {
        return "GitHubEvent [installationId=" + this.installationId + ", deliveryId=" + this.deliveryId + ", repository=" + String.valueOf(this.repository) + ", event=" + this.event + ", action=" + this.action + ", payload=" + this.payload + ", replayed=" + this.replayed + "]";
    }
}

