/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.config;

import io.quarkiverse.githubapp.ConfigFile;
import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.runtime.config.GitHubAppConfigurationException;
import io.quarkiverse.githubapp.runtime.config.GitHubAppRuntimeConfig;
import io.quarkiverse.githubapp.runtime.config.PrivateKeyConverter;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.Startup;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.security.PrivateKey;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.logging.Logger;

@Singleton
@Startup
public class CheckedConfigProvider {
    private static final Logger LOG = Logger.getLogger((String)GitHubEvent.class.getPackageName());
    private final GitHubAppRuntimeConfig gitHubAppRuntimeConfig;
    private final LaunchMode launchMode;
    private final Optional<PrivateKey> privateKey;
    private final Optional<String> webhookSecret;
    private final String webhookUrlPath;
    private final Set<String> missingPropertyKeys = new TreeSet<String>();

    @Inject
    CheckedConfigProvider(GitHubAppRuntimeConfig gitHubAppRuntimeConfig, LaunchMode launchMode) {
        this.gitHubAppRuntimeConfig = gitHubAppRuntimeConfig;
        this.launchMode = launchMode;
        Map<String, String> credentials = this.getCredentials();
        String privateKey = credentials.get("githubAppPrivateKey");
        if (privateKey == null || privateKey.isBlank()) {
            privateKey = gitHubAppRuntimeConfig.privateKey().orElse(null);
        }
        this.privateKey = privateKey != null ? Optional.of(new PrivateKeyConverter().convert(privateKey.trim())) : Optional.empty();
        String webhookSecretFromCredentials = credentials.get("githubAppWebhookSecret");
        this.webhookSecret = webhookSecretFromCredentials != null && !webhookSecretFromCredentials.isBlank() ? Optional.of(webhookSecretFromCredentials.trim()) : gitHubAppRuntimeConfig.webhookSecret();
        Object object = this.webhookUrlPath = gitHubAppRuntimeConfig.webhookUrlPath().startsWith("/") ? gitHubAppRuntimeConfig.webhookUrlPath() : "/" + gitHubAppRuntimeConfig.webhookUrlPath();
        if (gitHubAppRuntimeConfig.appId().isEmpty()) {
            this.missingPropertyKeys.add("quarkus.github-app.app-id (.env: QUARKUS_GITHUB_APP_APP_ID)");
        }
        if (this.privateKey.isEmpty()) {
            this.missingPropertyKeys.add("quarkus.github-app.private-key (.env: QUARKUS_GITHUB_APP_PRIVATE_KEY)");
        }
        if (launchMode == LaunchMode.NORMAL && this.webhookSecret.isEmpty()) {
            this.missingPropertyKeys.add("quarkus.github-app.webhook-secret (.env: QUARKUS_GITHUB_APP_WEBHOOK_SECRET)");
        }
        if (launchMode != LaunchMode.TEST) {
            this.checkConfig();
        }
        if (this.webhookSecret.isPresent() && launchMode.isDevOrTest()) {
            LOG.info((Object)"Payload signature checking is disabled in dev and test modes.");
        }
    }

    public String appId() {
        if (this.launchMode == LaunchMode.TEST) {
            this.checkConfig();
        }
        return this.gitHubAppRuntimeConfig.appId().orElseThrow();
    }

    public Optional<String> appName() {
        return this.gitHubAppRuntimeConfig.appName();
    }

    public PrivateKey privateKey() {
        if (this.launchMode == LaunchMode.TEST) {
            this.checkConfig();
        }
        return this.privateKey.orElseThrow();
    }

    public Optional<String> webhookSecret() {
        return this.webhookSecret;
    }

    public Optional<String> webhookProxyUrl() {
        return this.gitHubAppRuntimeConfig.webhookProxyUrl();
    }

    public String restApiEndpoint() {
        return this.gitHubAppRuntimeConfig.restApiEndpoint();
    }

    public String webhookUrlPath() {
        return this.webhookUrlPath;
    }

    public String graphqlApiEndpoint() {
        return this.gitHubAppRuntimeConfig.graphqlApiEndpoint();
    }

    public Optional<String> personalAccessToken() {
        return this.gitHubAppRuntimeConfig.personalAccessToken();
    }

    public boolean checkInstallationTokenValidity() {
        return this.gitHubAppRuntimeConfig.checkInstallationTokenValidity();
    }

    public GitHubAppRuntimeConfig.Debug debug() {
        return this.gitHubAppRuntimeConfig.debug();
    }

    public GitHubAppRuntimeConfig.Telemetry telemetry() {
        return this.gitHubAppRuntimeConfig.telemetry();
    }

    public ConfigFile.Source getEffectiveSource(ConfigFile.Source source) {
        if (source == ConfigFile.Source.DEFAULT) {
            return this.gitHubAppRuntimeConfig.readConfigFilesFromSourceRepository() ? ConfigFile.Source.SOURCE_REPOSITORY : ConfigFile.Source.CURRENT_REPOSITORY;
        }
        return source;
    }

    public void checkConfig() {
        if (this.missingPropertyKeys.isEmpty()) {
            return;
        }
        String errorMessage = this.launchMode == LaunchMode.TEST ? "\n\nMissing values for configuration properties:\n- " + String.join((CharSequence)"\n- ", this.missingPropertyKeys) + "\n\nThis configuration is necessary to create the GitHub clients.It is optional in tests only if GitHub clients are being mocked using quarkus-github-app-testing.\n\nFor more information, see https://docs.quarkiverse.io/quarkus-github-app/dev/testing.html." : "\n\nMissing values for configuration properties:\n- " + String.join((CharSequence)"\n- ", this.missingPropertyKeys) + "\n\nThis configuration is required in " + (this.launchMode == LaunchMode.NORMAL ? "prod" : "dev") + " mode.\n\nFor more information, see:\n- https://docs.quarkiverse.io/quarkus-github-app/dev/register-github-app.html\n- https://docs.quarkiverse.io/quarkus-github-app/dev/create-github-app.html#_initialize_the_configuration";
        throw new GitHubAppConfigurationException(errorMessage);
    }

    private Map<String, String> getCredentials() {
        if (this.gitHubAppRuntimeConfig.credentialsProvider().isEmpty()) {
            return Map.of();
        }
        String beanName = this.gitHubAppRuntimeConfig.credentialsProviderName().orElse(null);
        try (InstanceHandle<CredentialsProvider> credentialsProviderInstance = CheckedConfigProvider.getCredentialsProvider(beanName);){
            if (credentialsProviderInstance == null) {
                throw new RuntimeException("Unable to find credentials provider of name " + (beanName == null ? "default" : beanName));
            }
            String keyRingName = this.gitHubAppRuntimeConfig.credentialsProvider().get();
            Map map = ((CredentialsProvider)credentialsProviderInstance.get()).getCredentials(keyRingName);
            return map;
        }
    }

    private static InstanceHandle<CredentialsProvider> getCredentialsProvider(String name) {
        ArcContainer container = Arc.container();
        InstanceHandle credentialsProvider = name != null ? container.instance(name) : container.instance(CredentialsProvider.class, new Annotation[0]);
        return credentialsProvider;
    }
}

