/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.error;

import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.error.ErrorHandler;
import io.quarkiverse.githubapp.runtime.error.GitHubEventDispatchingException;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;

public class ErrorHandlerBridgeFunction
implements BiFunction<GitHubEvent, Throwable, Void> {
    private static final Logger LOG = Logger.getLogger(ErrorHandlerBridgeFunction.class);
    public static final ErrorHandlerBridgeFunction INSTANCE = new ErrorHandlerBridgeFunction();

    @Override
    public Void apply(GitHubEvent gitHubEvent, Throwable t) {
        InstanceHandle errorHandler = Arc.container().instance(ErrorHandler.class, new Annotation[0]);
        try {
            if (errorHandler.isAvailable()) {
                ((ErrorHandler)errorHandler.get()).handleError(gitHubEvent, null, t);
            } else {
                LOG.error((Object)"An error occurred and no ErrorHandler is available", t);
            }
            throw new GitHubEventDispatchingException("Error dispatching event: " + gitHubEvent.getDeliveryId() + " of type: " + gitHubEvent.getEventAction(), t);
        }
        catch (Throwable throwable) {
            if (errorHandler != null) {
                try {
                    errorHandler.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }
}

