/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.github;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.quarkiverse.githubapp.GitHubClientProvider;
import io.quarkiverse.githubapp.GitHubCustomizer;
import io.quarkiverse.githubapp.InstallationTokenProvider;
import io.quarkiverse.githubapp.JavaHttpClientFactory;
import io.quarkiverse.githubapp.runtime.config.CheckedConfigProvider;
import io.quarkiverse.githubapp.runtime.signing.JwtTokenCreator;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHAppInstallationToken;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.connector.GitHubConnector;
import org.kohsuke.github.extras.HttpClientGitHubConnector;

@ApplicationScoped
public class GitHubService
implements GitHubClientProvider,
InstallationTokenProvider {
    private static final Logger LOG = Logger.getLogger(GitHubService.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_HEADER_BEARER = "Bearer %s";
    private static final GitHubCustomizer NOOP_GITHUB_CUSTOMIZER = new GitHubCustomizer(){

        @Override
        public void customize(GitHubBuilder builder) {
        }
    };
    private final CheckedConfigProvider checkedConfigProvider;
    private final LoadingCache<Long, CachedInstallationToken> installationTokenCache;
    private final JwtTokenCreator jwtTokenCreator;
    private final GitHubConnector gitHubConnector;
    private final GitHubCustomizer githubCustomizer;
    private final GitHub tokenRestClient;
    private final DynamicGraphQLClient tokenGraphQLClient;

    @Inject
    public GitHubService(CheckedConfigProvider checkedConfigProvider, JwtTokenCreator jwtTokenCreator, Instance<GitHubCustomizer> gitHubCustomizer) {
        this.checkedConfigProvider = checkedConfigProvider;
        this.jwtTokenCreator = jwtTokenCreator;
        this.installationTokenCache = Caffeine.newBuilder().maximumSize(100L).expireAfter((Expiry)new Expiry<Long, CachedInstallationToken>(){

            public long expireAfterCreate(Long installationId, CachedInstallationToken cachedInstallationGitHub, long currentTime) {
                long millis = cachedInstallationGitHub.expiresAt().minus(System.currentTimeMillis(), ChronoUnit.MILLIS).minus(10L, ChronoUnit.MINUTES).toEpochMilli();
                return TimeUnit.MILLISECONDS.toNanos(millis);
            }

            public long expireAfterUpdate(Long installationId, CachedInstallationToken cachedInstallationGitHub, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(Long installationId, CachedInstallationToken cachedInstallationGitHub, long currentTime, long currentDuration) {
                return currentDuration;
            }
        }).build((CacheLoader)new CreateInstallationToken());
        try (InstanceHandle javaHttpClientFactory = Arc.container().instance(JavaHttpClientFactory.class, new Annotation[0]);){
            this.gitHubConnector = new HttpClientGitHubConnector(((JavaHttpClientFactory)javaHttpClientFactory.get()).create());
        }
        GitHubCustomizer gitHubCustomizer2 = this.githubCustomizer = gitHubCustomizer.isResolvable() ? (GitHubCustomizer)gitHubCustomizer.get() : NOOP_GITHUB_CUSTOMIZER;
        if (checkedConfigProvider.personalAccessToken().isPresent()) {
            GitHub restClient = null;
            try {
                GitHubBuilder restClientBuilder = new GitHubBuilder().withConnector(this.gitHubConnector);
                this.githubCustomizer.customize(restClientBuilder);
                restClientBuilder.withEndpoint(checkedConfigProvider.restApiEndpoint()).withOAuthToken(checkedConfigProvider.personalAccessToken().get());
                restClient = restClientBuilder.build();
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to create a REST GitHub client with provided personal access token", (Throwable)e);
            }
            this.tokenRestClient = restClient;
            this.tokenGraphQLClient = DynamicGraphQLClientBuilder.newBuilder().url(checkedConfigProvider.graphqlApiEndpoint()).header(AUTHORIZATION_HEADER, String.format(AUTHORIZATION_HEADER_BEARER, checkedConfigProvider.personalAccessToken().get())).build();
        } else {
            this.tokenRestClient = null;
            this.tokenGraphQLClient = null;
        }
    }

    @Override
    public GitHub getInstallationClient(long installationId) {
        try {
            return this.createInstallationClient(installationId);
        }
        catch (IOException e1) {
            GitHubService gitHubService = this;
            synchronized (gitHubService) {
                try {
                    return this.createInstallationClient(installationId);
                }
                catch (IOException e2) {
                    try {
                        this.installationTokenCache.invalidate((Object)installationId);
                        return this.createInstallationClient(installationId);
                    }
                    catch (IOException e3) {
                        throw new IllegalStateException("Unable to create a GitHub client for the installation " + installationId, e3);
                    }
                }
            }
        }
    }

    @Override
    public DynamicGraphQLClient getInstallationGraphQLClient(long installationId) {
        try {
            return this.createInstallationGraphQLClient(installationId);
        }
        catch (IOException | InterruptedException | ExecutionException e1) {
            GitHubService gitHubService = this;
            synchronized (gitHubService) {
                try {
                    return this.createInstallationGraphQLClient(installationId);
                }
                catch (IOException | InterruptedException | ExecutionException e2) {
                    try {
                        this.installationTokenCache.invalidate((Object)installationId);
                        return this.createInstallationGraphQLClient(installationId);
                    }
                    catch (IOException | InterruptedException | ExecutionException e3) {
                        throw new IllegalStateException("Unable to create a GitHub GraphQL client for the installation " + installationId, e3);
                    }
                }
            }
        }
    }

    @Override
    public InstallationTokenProvider.InstallationToken getInstallationToken(long installationId) {
        return (InstallationTokenProvider.InstallationToken)this.installationTokenCache.get((Object)installationId);
    }

    private GitHub createInstallationClient(long installationId) throws IOException {
        CachedInstallationToken installationToken = (CachedInstallationToken)this.installationTokenCache.get((Object)installationId);
        GitHubBuilder gitHubBuilder = new GitHubBuilder().withConnector(this.gitHubConnector);
        this.githubCustomizer.customize(gitHubBuilder);
        gitHubBuilder.withAppInstallationToken(installationToken.token()).withEndpoint(this.checkedConfigProvider.restApiEndpoint());
        GitHub gitHub = gitHubBuilder.build();
        if (this.checkedConfigProvider.checkInstallationTokenValidity()) {
            gitHub.getRateLimit();
        }
        return gitHub;
    }

    private DynamicGraphQLClient createInstallationGraphQLClient(long installationId) throws IOException, ExecutionException, InterruptedException {
        CachedInstallationToken installationToken = (CachedInstallationToken)this.installationTokenCache.get((Object)installationId);
        DynamicGraphQLClient graphQLClient = DynamicGraphQLClientBuilder.newBuilder().url(this.checkedConfigProvider.graphqlApiEndpoint()).header(AUTHORIZATION_HEADER, String.format(AUTHORIZATION_HEADER_BEARER, installationToken.token())).build();
        if (this.checkedConfigProvider.checkInstallationTokenValidity()) {
            graphQLClient.executeSync("query {\nrateLimit {\n    limit\n    cost\n    remaining\n    resetAt\n  }\n}");
        }
        return graphQLClient;
    }

    @Override
    public GitHub getApplicationClient() {
        return this.createApplicationGitHub();
    }

    public GitHub getTokenRestClient() {
        if (this.tokenRestClient == null) {
            throw new IllegalStateException("No personal access token was provided or we were unable to create the GitHub REST client. You can either use the injectable GitHub client or fix the issue if you absolutely need a client authenticated with a personal access token.");
        }
        return this.tokenRestClient;
    }

    public DynamicGraphQLClient getTokenGraphQLClient() {
        if (this.tokenGraphQLClient == null) {
            throw new IllegalStateException("No personal access token was provided. You can either use the injectable GraphQL client (if available) or fix the issue if you absolutely need a client authenticated with a personal access token.");
        }
        return this.tokenGraphQLClient;
    }

    public GitHub getTokenOrApplicationClient() {
        if (this.tokenRestClient != null) {
            return this.tokenRestClient;
        }
        return this.getApplicationClient();
    }

    public DynamicGraphQLClient getTokenGraphQLClientOrNull() {
        if (this.tokenGraphQLClient != null) {
            return this.tokenGraphQLClient;
        }
        return null;
    }

    @PreDestroy
    void destroy() {
        if (this.tokenGraphQLClient != null) {
            try {
                this.tokenGraphQLClient.close();
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to close the GraphQL client", (Throwable)e);
            }
        }
    }

    private GitHub createApplicationGitHub() {
        String jwtToken;
        try {
            jwtToken = this.jwtTokenCreator.createJwtToken(this.checkedConfigProvider.appId(), this.checkedConfigProvider.privateKey(), 540L);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Unable to generate the JWT token", e);
        }
        try {
            GitHubBuilder gitHubBuilder = new GitHubBuilder().withConnector(this.gitHubConnector);
            this.githubCustomizer.customizeApplicationClient(gitHubBuilder);
            gitHubBuilder.withJwtToken(jwtToken).withEndpoint(this.checkedConfigProvider.restApiEndpoint());
            return gitHubBuilder.build();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create a GitHub client for the application", e);
        }
    }

    private class CreateInstallationToken
    implements CacheLoader<Long, CachedInstallationToken> {
        private CreateInstallationToken() {
        }

        public CachedInstallationToken load(Long installationId) throws Exception {
            try {
                GHAppInstallationToken installationToken = GitHubService.this.createApplicationGitHub().getApp().getInstallationById(installationId.longValue()).createToken().create();
                return new CachedInstallationToken(installationToken.getToken(), installationToken.getExpiresAt().toInstant());
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create a GitHub token for the installation " + installationId, e);
            }
        }
    }

    private record CachedInstallationToken(String token, Instant expiresAt) implements InstallationTokenProvider.InstallationToken
    {
    }
}

