/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.github;

import java.io.IOException;
import java.util.Optional;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHRepository;

public final class PayloadHelper {
    public static GHRepository getRepository(GHEventPayload eventPayload) {
        GHRepository repository = eventPayload.getRepository();
        if (repository == null) {
            throw new IllegalStateException("Unable to extract repository information from payload type: " + eventPayload.getClass().getName() + ". This is needed for config files.");
        }
        return repository;
    }

    public static Optional<String> getContext(GHEventPayload eventPayload) {
        if (eventPayload instanceof GHEventPayload.CheckRun) {
            GHEventPayload.CheckRun checkRun = (GHEventPayload.CheckRun)eventPayload;
            return Optional.of(checkRun.getCheckRun().getDetailsUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.CheckSuite) {
            GHEventPayload.CheckSuite checkSuite = (GHEventPayload.CheckSuite)eventPayload;
            return Optional.of(checkSuite.getCheckSuite().getCheckRunsUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.PullRequest) {
            GHEventPayload.PullRequest pullRequest = (GHEventPayload.PullRequest)eventPayload;
            return Optional.of(pullRequest.getPullRequest().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.PullRequestReview) {
            GHEventPayload.PullRequestReview pullRequestReview = (GHEventPayload.PullRequestReview)eventPayload;
            return Optional.of(pullRequestReview.getPullRequest().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.PullRequestReviewComment) {
            GHEventPayload.PullRequestReviewComment pullRequestReviewComment = (GHEventPayload.PullRequestReviewComment)eventPayload;
            return Optional.of(pullRequestReviewComment.getPullRequest().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Issue) {
            GHEventPayload.Issue issue = (GHEventPayload.Issue)eventPayload;
            return Optional.of(issue.getIssue().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.IssueComment) {
            GHEventPayload.IssueComment issueComment = (GHEventPayload.IssueComment)eventPayload;
            return Optional.of(issueComment.getComment().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.CommitComment) {
            GHEventPayload.CommitComment commitComment = (GHEventPayload.CommitComment)eventPayload;
            return Optional.of(commitComment.getComment().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Create) {
            GHEventPayload.Create create = (GHEventPayload.Create)eventPayload;
            return Optional.of(create.getRepository().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Delete) {
            GHEventPayload.Delete delete = (GHEventPayload.Delete)eventPayload;
            return Optional.of(delete.getRepository().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Deployment) {
            GHEventPayload.Deployment deployment = (GHEventPayload.Deployment)eventPayload;
            return Optional.of(deployment.getDeployment().getStatusesUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.DeploymentStatus) {
            GHEventPayload.DeploymentStatus deploymentStatus = (GHEventPayload.DeploymentStatus)eventPayload;
            return Optional.of(deploymentStatus.getDeploymentStatus().getDeploymentUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Fork) {
            GHEventPayload.Fork fork = (GHEventPayload.Fork)eventPayload;
            return Optional.of(fork.getForkee().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Public) {
            GHEventPayload.Public publicEvent = (GHEventPayload.Public)eventPayload;
            return Optional.of(publicEvent.getRepository().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Push) {
            GHEventPayload.Push push = (GHEventPayload.Push)eventPayload;
            return Optional.of(push.getRef());
        }
        if (eventPayload instanceof GHEventPayload.Release) {
            GHEventPayload.Release release = (GHEventPayload.Release)eventPayload;
            return Optional.of(release.getRelease().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Repository) {
            GHEventPayload.Repository repositoryEvent = (GHEventPayload.Repository)eventPayload;
            return Optional.of(repositoryEvent.getRepository().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Status) {
            GHEventPayload.Status status = (GHEventPayload.Status)eventPayload;
            return Optional.of(status.getDescription());
        }
        if (eventPayload instanceof GHEventPayload.WorkflowDispatch) {
            GHEventPayload.WorkflowDispatch workflowDispatch = (GHEventPayload.WorkflowDispatch)eventPayload;
            return Optional.of(workflowDispatch.getRepository().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.WorkflowRun) {
            GHEventPayload.WorkflowRun workflowRun = (GHEventPayload.WorkflowRun)eventPayload;
            try {
                return Optional.of(workflowRun.getWorkflowRun().getHtmlUrl().toString());
            }
            catch (IOException e) {
                return Optional.of(workflowRun.getRepository().getHtmlUrl().toString());
            }
        }
        if (eventPayload instanceof GHEventPayload.WorkflowJob) {
            GHEventPayload.WorkflowJob workflowJob = (GHEventPayload.WorkflowJob)eventPayload;
            return Optional.of(workflowJob.getWorkflowJob().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Label) {
            GHEventPayload.Label label = (GHEventPayload.Label)eventPayload;
            return Optional.of(label.getRepository().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Discussion) {
            GHEventPayload.Discussion discussion = (GHEventPayload.Discussion)eventPayload;
            return Optional.of(discussion.getDiscussion().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.DiscussionComment) {
            GHEventPayload.DiscussionComment discussionComment = (GHEventPayload.DiscussionComment)eventPayload;
            return Optional.of(discussionComment.getComment().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Star) {
            GHEventPayload.Star star = (GHEventPayload.Star)eventPayload;
            return Optional.of(star.getRepository().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.ProjectsV2Item) {
            GHEventPayload.ProjectsV2Item projectsV2Item = (GHEventPayload.ProjectsV2Item)eventPayload;
            return Optional.of(projectsV2Item.getRepository().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.TeamAdd) {
            GHEventPayload.TeamAdd teamAdd = (GHEventPayload.TeamAdd)eventPayload;
            return Optional.of(teamAdd.getTeam().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Team) {
            GHEventPayload.Team team = (GHEventPayload.Team)eventPayload;
            return Optional.of(team.getTeam().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Member) {
            GHEventPayload.Member member = (GHEventPayload.Member)eventPayload;
            return Optional.of(member.getRepository().getHtmlUrl().toString());
        }
        if (eventPayload instanceof GHEventPayload.Membership) {
            GHEventPayload.Membership membership = (GHEventPayload.Membership)eventPayload;
            return Optional.of(membership.getTeam().getHtmlUrl().toString());
        }
        return Optional.empty();
    }

    private PayloadHelper() {
    }
}

