/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.telemetry.opentelemetry;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.quarkiverse.githubapp.GitHubEvent;

public class OpenTelemetryAttributes {
    public static final AttributeKey<Long> INSTALLATION_ID = AttributeKey.longKey((String)"gitHubEvent.installationId");
    public static final AttributeKey<String> APP_NAME = AttributeKey.stringKey((String)"gitHubEvent.appName");
    public static final AttributeKey<String> DELIVERY_ID = AttributeKey.stringKey((String)"gitHubEvent.deliveryId");
    public static final AttributeKey<String> REPOSITORY = AttributeKey.stringKey((String)"gitHubEvent.repository");
    public static final AttributeKey<String> EVENT = AttributeKey.stringKey((String)"gitHubEvent.event");
    public static final AttributeKey<String> EVENT_ACTION = AttributeKey.stringKey((String)"gitHubEvent.eventAction");
    public static final AttributeKey<String> PAYLOAD = AttributeKey.stringKey((String)"gitHubEvent.payload");
    public static final AttributeKey<String> CLASS = AttributeKey.stringKey((String)"gitHubEvent.eventMethod.class");
    public static final AttributeKey<String> METHOD = AttributeKey.stringKey((String)"gitHubEvent.eventMethod.method");
    public static final AttributeKey<String> METHOD_SIGNATURE = AttributeKey.stringKey((String)"gitHubEvent.eventMethod.methodSignature");
    public static final AttributeKey<String> OUTCOME = AttributeKey.stringKey((String)"outcome");
    public static final AttributeKey<String> ERROR_MESSAGE = AttributeKey.stringKey((String)"errorMessage");
    public static final String STATUS_FAILURE = "failure";
    public static final String STATUS_SUCCESS = "success";
    public static final AttributeKey<String> ERROR_TYPE = AttributeKey.stringKey((String)"errorType");
    public static final AttributeKey<String> COMMAND_CLASS = AttributeKey.stringKey((String)"command.class");
    public static final AttributeKey<String> COMMAND_LINE = AttributeKey.stringKey((String)"command.commandLine");

    static void putSpanGitHubEventAttributes(AttributesBuilder attributesBuilder, GitHubEvent gitHubEvent) {
        attributesBuilder.put(DELIVERY_ID, (Object)gitHubEvent.getDeliveryId());
        attributesBuilder.put(INSTALLATION_ID, (Object)gitHubEvent.getInstallationId());
        if (gitHubEvent.getAppName().isPresent()) {
            attributesBuilder.put(APP_NAME, (Object)gitHubEvent.getAppName().get());
        }
    }

    static void putCommonGitHubEventAttributes(AttributesBuilder attributesBuilder, GitHubEvent gitHubEvent) {
        if (gitHubEvent.getRepository().isPresent()) {
            attributesBuilder.put(REPOSITORY, (Object)gitHubEvent.getRepository().get());
        }
        attributesBuilder.put(EVENT, (Object)gitHubEvent.getEvent());
        attributesBuilder.put(EVENT_ACTION, (Object)gitHubEvent.getEventAction());
    }

    static void putCommonGitHubEventMethodAttributes(AttributesBuilder attributesBuilder, String className, String methodName, String signature) {
        attributesBuilder.put(CLASS, (Object)className);
        attributesBuilder.put(METHOD, (Object)methodName);
        attributesBuilder.put(METHOD_SIGNATURE, (Object)signature);
    }

    static void putSuccessAttributes(AttributesBuilder attributesBuilder) {
        attributesBuilder.put(OUTCOME, (Object)STATUS_SUCCESS);
    }

    static void putErrorAttributes(AttributesBuilder attributesBuilder, Throwable throwable) {
        attributesBuilder.put(OUTCOME, (Object)STATUS_FAILURE);
        attributesBuilder.put(ERROR_MESSAGE, (Object)throwable.getMessage());
    }

    static void putCommonCommandAttributes(AttributesBuilder attributesBuilder, String commandClassName) {
        if (commandClassName != null) {
            attributesBuilder.put(COMMAND_CLASS, (Object)commandClassName);
        }
    }

    static void putCommandSuccessAttributes(AttributesBuilder attributesBuilder) {
        attributesBuilder.put(OUTCOME, (Object)STATUS_SUCCESS);
    }

    static void putCommandErrorAttributes(AttributesBuilder attributesBuilder, CommandErrorType errorType, String errorMessage) {
        attributesBuilder.put(OUTCOME, (Object)STATUS_FAILURE);
        attributesBuilder.put(ERROR_TYPE, (Object)errorType.name());
        if (errorMessage != null) {
            attributesBuilder.put(ERROR_MESSAGE, (Object)errorMessage);
        }
    }

    public static enum CommandErrorType {
        PARSE_ERROR,
        PERMISSION_ERROR,
        EXECUTION_ERROR;

    }
}

