/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.telemetry.opentelemetry;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.runtime.config.CheckedConfigProvider;
import io.quarkiverse.githubapp.runtime.telemetry.opentelemetry.OpenTelemetryAttributes;
import io.quarkiverse.githubapp.telemetry.TelemetryMetricsReporter;
import io.quarkus.arc.DefaultBean;
import jakarta.inject.Singleton;

@Singleton
@DefaultBean
public class OpenTelemetryMetricsReporter
implements TelemetryMetricsReporter {
    private final LongCounter gitHubEventCounter;
    private final LongCounter gitHubEventMethodCounter;
    private final LongCounter commandMethodCounter;
    private final boolean metricsActive;

    OpenTelemetryMetricsReporter(Meter meter, CheckedConfigProvider checkedConfigProvider) {
        this.metricsActive = checkedConfigProvider.telemetry().metricsActive();
        if (this.metricsActive) {
            this.gitHubEventCounter = meter.counterBuilder("github-app.github-event").setDescription("Counts total GitHub events handled").setUnit("event").build();
            this.gitHubEventMethodCounter = meter.counterBuilder("github-app.github-event.method").setDescription("Counts total invocations of GitHub event methods").setUnit("invocation").build();
            this.commandMethodCounter = meter.counterBuilder("github-app.command.method").setDescription("Counts total invocations of commands").setUnit("invocation").build();
        } else {
            this.gitHubEventCounter = null;
            this.gitHubEventMethodCounter = null;
            this.commandMethodCounter = null;
        }
    }

    @Override
    public void incrementGitHubEventSuccess(GitHubEvent gitHubEvent) {
        if (!this.metricsActive) {
            return;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putSuccessAttributes(attributesBuilder);
        OpenTelemetryAttributes.putCommonGitHubEventAttributes(attributesBuilder, gitHubEvent);
        this.gitHubEventCounter.add(1L, attributesBuilder.build());
    }

    @Override
    public void incrementGitHubEventError(GitHubEvent gitHubEvent, Throwable throwable) {
        if (!this.metricsActive) {
            return;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putErrorAttributes(attributesBuilder, throwable);
        OpenTelemetryAttributes.putCommonGitHubEventAttributes(attributesBuilder, gitHubEvent);
        this.gitHubEventCounter.add(1L, attributesBuilder.build());
    }

    @Override
    public void incrementGitHubEventMethodSuccess(GitHubEvent gitHubEvent, String className, String methodName, String signature) {
        if (!this.metricsActive) {
            return;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putSuccessAttributes(attributesBuilder);
        OpenTelemetryAttributes.putCommonGitHubEventAttributes(attributesBuilder, gitHubEvent);
        OpenTelemetryAttributes.putCommonGitHubEventMethodAttributes(attributesBuilder, className, methodName, signature);
        this.gitHubEventMethodCounter.add(1L, attributesBuilder.build());
    }

    @Override
    public void incrementGitHubEventMethodError(GitHubEvent gitHubEvent, String className, String methodName, String signature, Throwable throwable) {
        if (!this.metricsActive) {
            return;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putErrorAttributes(attributesBuilder, throwable);
        OpenTelemetryAttributes.putCommonGitHubEventAttributes(attributesBuilder, gitHubEvent);
        OpenTelemetryAttributes.putCommonGitHubEventMethodAttributes(attributesBuilder, className, methodName, signature);
        this.gitHubEventMethodCounter.add(1L, attributesBuilder.build());
    }

    @Override
    public void incrementCommandMethodSuccess(GitHubEvent gitHubEvent, String commandClassName) {
        if (!this.metricsActive) {
            return;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putCommonCommandAttributes(attributesBuilder, commandClassName);
        OpenTelemetryAttributes.putCommonGitHubEventAttributes(attributesBuilder, gitHubEvent);
        OpenTelemetryAttributes.putCommandSuccessAttributes(attributesBuilder);
        this.commandMethodCounter.add(1L, attributesBuilder.build());
    }

    @Override
    public void incrementCommandMethodError(GitHubEvent gitHubEvent, String commandClassName, OpenTelemetryAttributes.CommandErrorType errorType, String errorMessage) {
        if (!this.metricsActive) {
            return;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putCommonCommandAttributes(attributesBuilder, commandClassName);
        OpenTelemetryAttributes.putCommonGitHubEventAttributes(attributesBuilder, gitHubEvent);
        OpenTelemetryAttributes.putCommandErrorAttributes(attributesBuilder, errorType, errorMessage);
        this.commandMethodCounter.add(1L, attributesBuilder.build());
    }
}

