/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.telemetry.opentelemetry;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.runtime.config.CheckedConfigProvider;
import io.quarkiverse.githubapp.runtime.telemetry.noop.NoopTelemetryTracesReporter;
import io.quarkiverse.githubapp.runtime.telemetry.opentelemetry.OpenTelemetryAttributes;
import io.quarkiverse.githubapp.runtime.telemetry.opentelemetry.OpenTelemetryDecoratedGitHubEvent;
import io.quarkiverse.githubapp.telemetry.TelemetryScopeWrapper;
import io.quarkiverse.githubapp.telemetry.TelemetrySpanWrapper;
import io.quarkiverse.githubapp.telemetry.TelemetryTracesReporter;
import io.quarkus.arc.DefaultBean;
import jakarta.inject.Singleton;

@Singleton
@DefaultBean
public class OpenTelemetryTracesReporter
implements TelemetryTracesReporter {
    private static final NoopTelemetryTracesReporter NOOP_INSTANCE = new NoopTelemetryTracesReporter();
    private final Tracer tracer;
    private final boolean tracesActive;
    private final boolean recordEventPayload;
    private final boolean recordCommand;

    OpenTelemetryTracesReporter(Tracer tracer, CheckedConfigProvider checkedConfigProvider) {
        this.tracer = tracer;
        this.tracesActive = checkedConfigProvider.telemetry().tracesActive();
        this.recordEventPayload = checkedConfigProvider.telemetry().recordEventPayload();
        this.recordCommand = checkedConfigProvider.telemetry().recordCommand();
    }

    @Override
    public void reportEarlyRequestError(String deliveryId, String event, String error) {
        if (!this.tracesActive) {
            return;
        }
        Span requestSpan = Span.current();
        if (!requestSpan.getSpanContext().isValid()) {
            return;
        }
        requestSpan.setAttribute(OpenTelemetryAttributes.DELIVERY_ID, (Object)deliveryId);
        requestSpan.setAttribute(OpenTelemetryAttributes.EVENT, (Object)event);
        requestSpan.setStatus(StatusCode.ERROR, error);
    }

    @Override
    public TelemetrySpanWrapper createGitHubEventSpan(GitHubEvent gitHubEvent) {
        if (!this.tracesActive) {
            return NOOP_INSTANCE.createGitHubEventSpan(gitHubEvent);
        }
        SpanBuilder spanBuilder = this.tracer.spanBuilder("github-app.github-event".concat(" ").concat(gitHubEvent.getEventAction()));
        spanBuilder.setSpanKind(SpanKind.INTERNAL);
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putSpanGitHubEventAttributes(attributesBuilder, gitHubEvent);
        OpenTelemetryAttributes.putCommonGitHubEventAttributes(attributesBuilder, gitHubEvent);
        if (this.recordEventPayload) {
            attributesBuilder.put(OpenTelemetryAttributes.PAYLOAD, (Object)gitHubEvent.getPayload());
        }
        spanBuilder.setAllAttributes(attributesBuilder.build());
        return new OpenTelemetrySpanWrapper(spanBuilder.startSpan());
    }

    @Override
    public GitHubEvent decorateGitHubEvent(GitHubEvent originalGitHubEvent, TelemetrySpanWrapper spanWrapper) {
        if (!this.tracesActive) {
            return originalGitHubEvent;
        }
        return new OpenTelemetryDecoratedGitHubEvent(originalGitHubEvent, spanWrapper.as(OpenTelemetrySpanWrapper.class).span().getSpanContext());
    }

    @Override
    public TelemetrySpanWrapper createGitHubEventListeningMethodSpan(GitHubEvent gitHubEvent, String className, String methodName, String signature) {
        if (!this.tracesActive) {
            return NOOP_INSTANCE.createGitHubEventListeningMethodSpan(gitHubEvent, className, methodName, signature);
        }
        StringBuilder spanNameSb = new StringBuilder(className.length() + methodName.length() + 32);
        spanNameSb.append("github-app.github-event.method").append(" ").append(className).append(".").append(methodName);
        SpanBuilder eventMethodSpanBuilder = this.tracer.spanBuilder(spanNameSb.toString());
        eventMethodSpanBuilder.setSpanKind(SpanKind.INTERNAL);
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putSpanGitHubEventAttributes(attributesBuilder, gitHubEvent);
        OpenTelemetryAttributes.putCommonGitHubEventAttributes(attributesBuilder, gitHubEvent);
        OpenTelemetryAttributes.putCommonGitHubEventMethodAttributes(attributesBuilder, className, methodName, signature);
        eventMethodSpanBuilder.setAllAttributes(attributesBuilder.build());
        eventMethodSpanBuilder.addLink(gitHubEvent.as(OpenTelemetryDecoratedGitHubEvent.class).getRootSpanContext());
        return new OpenTelemetrySpanWrapper(eventMethodSpanBuilder.startSpan());
    }

    @Override
    public void reportSuccess(GitHubEvent gitHubEvent, TelemetrySpanWrapper spanWrapper) {
        if (!this.tracesActive) {
            return;
        }
        Span span = spanWrapper.as(OpenTelemetrySpanWrapper.class).span();
        span.setStatus(StatusCode.OK);
    }

    @Override
    public void reportException(GitHubEvent gitHubEvent, TelemetrySpanWrapper spanWrapper, Throwable e) {
        if (!this.tracesActive) {
            return;
        }
        Span span = spanWrapper.as(OpenTelemetrySpanWrapper.class).span();
        span.recordException(e);
        span.setStatus(StatusCode.ERROR, e.getMessage());
    }

    @Override
    public TelemetryScopeWrapper makeCurrent(TelemetrySpanWrapper spanWrapper) {
        if (!this.tracesActive) {
            return NOOP_INSTANCE.makeCurrent(spanWrapper);
        }
        return new OpenTelemetryScopeWrapper(spanWrapper.as(OpenTelemetrySpanWrapper.class).span().makeCurrent());
    }

    @Override
    public void endSpan(TelemetrySpanWrapper spanWrapper) {
        if (!this.tracesActive) {
            return;
        }
        spanWrapper.as(OpenTelemetrySpanWrapper.class).span().end();
    }

    @Override
    public void reportCommandMethodSuccess(GitHubEvent gitHubEvent, String commandClassName, String commandLine) {
        if (!this.tracesActive) {
            return;
        }
        Span span = Span.current();
        if (span == null) {
            return;
        }
        StringBuilder eventNameSb = new StringBuilder(commandClassName.length() + 26);
        eventNameSb.append("github-app.command.method").append(" ").append(commandClassName);
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putCommonCommandAttributes(attributesBuilder, commandClassName);
        OpenTelemetryAttributes.putCommandSuccessAttributes(attributesBuilder);
        if (this.recordCommand && commandLine != null) {
            attributesBuilder.put(OpenTelemetryAttributes.COMMAND_LINE, (Object)commandLine);
        }
        span.addEvent(eventNameSb.toString(), attributesBuilder.build());
    }

    @Override
    public void reportCommandMethodError(GitHubEvent gitHubEvent, String commandClassName, String commandLine, OpenTelemetryAttributes.CommandErrorType errorType, String errorMessage) {
        if (!this.tracesActive) {
            return;
        }
        Span span = Span.current();
        if (span == null) {
            return;
        }
        Object eventName = "github-app.command.method";
        if (commandClassName != null) {
            eventName = (String)eventName + " " + commandClassName;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryAttributes.putCommonCommandAttributes(attributesBuilder, commandClassName);
        OpenTelemetryAttributes.putCommandErrorAttributes(attributesBuilder, errorType, errorMessage);
        if (this.recordCommand && commandLine != null) {
            attributesBuilder.put(OpenTelemetryAttributes.COMMAND_LINE, (Object)commandLine);
        }
        span.addEvent((String)eventName, attributesBuilder.build());
    }

    private record OpenTelemetrySpanWrapper(Span span) implements TelemetrySpanWrapper
    {
    }

    private record OpenTelemetryScopeWrapper(Scope scope) implements TelemetryScopeWrapper
    {
        @Override
        public void close() throws Exception {
            this.scope.close();
        }
    }
}

