/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp;

import io.vertx.core.json.JsonObject;
import java.util.Optional;

public class GitHubEvent {
    private final Long installationId;
    private final Optional<String> appName;
    private final String deliveryId;
    private final Optional<String> repository;
    private final String event;
    private final String action;
    private final String payload;
    private final JsonObject parsedPayload;
    private final boolean replayed;

    public GitHubEvent(Long installationId, String appName, String deliveryId, String repository, String event, String action, String payload, JsonObject parsedPayload, boolean replayed) {
        this.installationId = installationId;
        this.appName = Optional.ofNullable(appName);
        this.deliveryId = deliveryId;
        this.repository = Optional.ofNullable(repository);
        this.event = event;
        this.action = action;
        this.payload = payload;
        this.parsedPayload = parsedPayload;
        this.replayed = replayed;
    }

    public Long getInstallationId() {
        return this.installationId;
    }

    public Optional<String> getAppName() {
        return this.appName;
    }

    public String getDeliveryId() {
        return this.deliveryId;
    }

    public Optional<String> getRepository() {
        return this.repository;
    }

    public String getRepositoryOrThrow() {
        return this.repository.orElseThrow(() -> new IllegalStateException("The payload did not provide any repository information"));
    }

    public String getEvent() {
        return this.event;
    }

    public String getAction() {
        return this.action;
    }

    public String getEventAction() {
        StringBuilder sb = new StringBuilder();
        if (this.event != null && !this.event.isBlank()) {
            sb.append(this.event);
        }
        if (this.action != null && !this.action.isBlank()) {
            sb.append(".").append(this.action);
        }
        return sb.toString();
    }

    public String getPayload() {
        return this.payload;
    }

    public JsonObject getParsedPayload() {
        return this.parsedPayload;
    }

    public boolean isReplayed() {
        return this.replayed;
    }

    public String toString() {
        return "GitHubEvent [installationId=" + this.installationId + ", deliveryId=" + this.deliveryId + ", repository=" + this.repository + ", event=" + this.event + ", action=" + this.action + ", payload=" + this.payload + ", replayed=" + this.replayed + "]";
    }
}

