/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.smee;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.githubapp.runtime.Headers;
import io.quarkiverse.githubapp.runtime.config.CheckedConfigProvider;
import io.quarkiverse.githubapp.runtime.sse.EventStreamListener;
import io.quarkiverse.githubapp.runtime.sse.HttpEventStreamClient;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.Startup;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Locale;
import org.jboss.logging.Logger;

@ApplicationScoped
@Startup
public class SmeeIoForwarder {
    private static final Logger LOG = Logger.getLogger(SmeeIoForwarder.class);
    private static final String EMPTY_MESSAGE = "{}";
    private final HttpEventStreamClient eventStreamClient;
    private final ReplayEventStreamAdapter replayEventStreamAdapter;

    @Inject
    SmeeIoForwarder(CheckedConfigProvider checkedConfigProvider, HttpConfiguration httpConfiguration, ObjectMapper objectMapper) {
        if (!checkedConfigProvider.webhookProxyUrl().isPresent()) {
            this.replayEventStreamAdapter = null;
            this.eventStreamClient = null;
            return;
        }
        LOG.info((Object)("Listening to events coming from " + checkedConfigProvider.webhookProxyUrl().get()));
        URI localUrl = URI.create("http://" + httpConfiguration.host + ":" + httpConfiguration.port + "/");
        this.replayEventStreamAdapter = new ReplayEventStreamAdapter(checkedConfigProvider.webhookProxyUrl().get(), localUrl, objectMapper);
        this.eventStreamClient = new HttpEventStreamClient(checkedConfigProvider.webhookProxyUrl().get(), this.replayEventStreamAdapter);
        this.eventStreamClient.setRetryCooldown(3000L);
        this.eventStreamClient.start();
    }

    void stopEventSource(@Observes ShutdownEvent shutdownEvent) {
        if (this.replayEventStreamAdapter != null) {
            this.replayEventStreamAdapter.stop();
        }
        if (this.eventStreamClient != null) {
            this.eventStreamClient.stop();
        }
    }

    private static class ReplayEventStreamAdapter
    implements EventStreamListener {
        private final String proxyUrl;
        private final URI localUrl;
        private final ObjectMapper objectMapper;
        private final HttpClient forwardingHttpClient;
        private volatile boolean stopped = false;

        private ReplayEventStreamAdapter(String proxyUrl, URI localUrl, ObjectMapper objectMapper) {
            this.proxyUrl = proxyUrl;
            this.localUrl = localUrl;
            this.objectMapper = objectMapper;
            this.forwardingHttpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(2L)).build();
        }

        @Override
        public void onEvent(HttpEventStreamClient client, HttpEventStreamClient.Event event) {
            if (this.stopped) {
                return;
            }
            if (SmeeIoForwarder.EMPTY_MESSAGE.equals(event.getData())) {
                return;
            }
            int startOfJsonObject = event.getData().indexOf(123);
            if (startOfJsonObject == -1) {
                return;
            }
            String data = event.getData().substring(startOfJsonObject);
            try {
                JsonNode rootNode = this.objectMapper.readTree(data);
                JsonNode body = rootNode.get("body");
                if (body != null) {
                    HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(this.localUrl).POST(HttpRequest.BodyPublishers.ofString(this.objectMapper.writeValueAsString((Object)rootNode.get("body"))));
                    for (String forwardedHeader : Headers.FORWARDED_HEADERS) {
                        JsonNode headerValue = rootNode.get(forwardedHeader.toLowerCase(Locale.ROOT));
                        if (headerValue == null || !headerValue.isTextual()) continue;
                        requestBuilder.header(forwardedHeader, headerValue.textValue());
                    }
                    this.forwardingHttpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.discarding());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"An error occurred while forwarding a payload to the local application running in dev mode", (Throwable)e);
            }
        }

        @Override
        public void onReconnect(HttpEventStreamClient client, HttpResponse<Void> response, boolean hasReceivedEvents, long lastEventID) {
            if (this.stopped) {
                return;
            }
            LOG.info((Object)("Reconnected to " + this.proxyUrl));
        }

        @Override
        public void onError(HttpEventStreamClient client, Throwable throwable) {
            if (this.stopped) {
                return;
            }
            LOG.error((Object)"An error occurred with Smee.io proxying", throwable);
        }

        @Override
        public void onClose(HttpEventStreamClient client, HttpResponse<Void> response) {
        }

        public void stop() {
            this.stopped = true;
        }
    }
}

