/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.sse;

import io.quarkiverse.githubapp.runtime.sse.EventStreamAdapter;
import io.quarkiverse.githubapp.runtime.sse.EventStreamListener;
import io.quarkiverse.githubapp.runtime.sse.HttpRequestMethod;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class HttpEventStreamClient {
    protected URI uri;
    protected HttpRequestMethod method = HttpRequestMethod.GET;
    protected HttpRequest.BodyPublisher requestBody = null;
    protected HttpClient.Version version = null;
    protected TreeMap<String, String> headers = new TreeMap();
    protected long timeout;
    protected long retryCooldown;
    protected int maxReconnectsWithoutEvents;
    protected final AtomicBoolean hasReceivedEvents = new AtomicBoolean(false);
    protected final AtomicInteger reconnectWithoutEvents = new AtomicInteger(0);
    protected HttpClient client = null;
    protected long lastEventID = 0L;
    protected boolean resetEventIDonReconnect;
    protected HashSet<EventStreamListener> listeners = new HashSet();
    protected HashSet<InternalEventStreamAdapter> internalListeners = new HashSet();
    protected CompletableFuture<HttpResponse<Void>> running = null;

    public HttpEventStreamClient(String url, EventStreamListener ... listener) {
        this(url, null, null, null, null, -1L, -1L, -1, false, null, listener);
    }

    public HttpEventStreamClient(String url, Map<String, String> headers, EventStreamListener ... listener) {
        this(url, null, null, null, headers, -1L, -1L, -1, false, null, listener);
    }

    public HttpEventStreamClient(String url, HttpRequestMethod method, HttpRequest.BodyPublisher requestBody, Map<String, String> headers, EventStreamListener ... listener) {
        this(url, method, requestBody, null, headers, -1L, -1L, -1, false, null, listener);
    }

    public HttpEventStreamClient(String url, HttpRequestMethod method, HttpRequest.BodyPublisher requestBody, Map<String, String> headers, long timeout, long retryCooldown, EventStreamListener ... listener) {
        this(url, method, requestBody, null, headers, timeout, retryCooldown, -1, false, null, listener);
    }

    public HttpEventStreamClient(String url, HttpRequestMethod method, HttpRequest.BodyPublisher requestBody, HttpClient.Version version, Map<String, String> headers, long timeout, long retryCooldown, int maxReconnectsWithoutEvents, boolean resetEventIDonReconnect, HttpClient client, EventStreamListener ... listener) {
        this.uri = URI.create(url);
        this.method = method != null ? method : this.method;
        this.requestBody = requestBody;
        this.version = version;
        this.timeout = timeout;
        this.retryCooldown = retryCooldown;
        this.maxReconnectsWithoutEvents = maxReconnectsWithoutEvents;
        this.resetEventIDonReconnect = resetEventIDonReconnect;
        this.client = client;
        this.setHeaders(headers);
        this.addListener(listener);
    }

    public URI getURI() {
        return this.uri;
    }

    public String getURL() {
        return this.uri.toString();
    }

    public void setURL(String url) {
        this.uri = URI.create(url);
    }

    public void setURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("URI cannot be null");
        }
        this.uri = uri;
    }

    public HttpRequestMethod getHttpMethod() {
        return this.method;
    }

    public void setHttpMethod(HttpRequestMethod method) {
        this.method = method != null ? method : HttpRequestMethod.GET;
    }

    public HttpRequest.BodyPublisher getHttpRequestBody() {
        return this.requestBody;
    }

    public void setHttpRequestBody(HttpRequest.BodyPublisher requestBody) {
        this.requestBody = requestBody;
    }

    public HttpClient.Version getHttpVersion() {
        return this.version;
    }

    public void setHttpVersion(HttpClient.Version version) {
        this.version = version;
    }

    public synchronized Map<String, String> getHeaders() {
        return new TreeMap<String, String>((SortedMap<String, String>)this.headers);
    }

    public synchronized void addHeaders(Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.put(entry.getKey().trim().toLowerCase(), entry.getValue());
        }
    }

    public synchronized void setHeaders(Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        this.headers.clear();
        this.addHeaders(headers);
    }

    public synchronized void setHeader(String key, String value) {
        if (key == null || key.isBlank()) {
            throw new NullPointerException("Key cannot be null or blank");
        }
        if (value != null && !value.isBlank()) {
            this.headers.put(key.trim().toLowerCase(), value);
        } else {
            this.headers.remove(key.trim().toLowerCase());
        }
    }

    public synchronized String getHeader(String key) {
        return key != null ? this.headers.get(key.trim().toLowerCase()) : null;
    }

    public synchronized String removeHeader(String key) {
        if (key == null) {
            return null;
        }
        return this.headers.remove(key.trim().toLowerCase());
    }

    public synchronized void removeHeaders(String ... keys) {
        if (keys == null) {
            return;
        }
        for (String key : keys) {
            this.headers.remove(key.trim().toLowerCase());
        }
    }

    public synchronized void clearHeaders() {
        this.headers.clear();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getRetryCooldown() {
        return this.retryCooldown;
    }

    public void setRetryCooldown(long retryCooldown) {
        this.retryCooldown = retryCooldown;
    }

    public boolean isAutoStopIfNoEventsEnabled() {
        return this.maxReconnectsWithoutEvents > 0;
    }

    public boolean isReconnectEnabled() {
        return this.maxReconnectsWithoutEvents != 0;
    }

    public int getAutoStopThreshold() {
        return this.maxReconnectsWithoutEvents;
    }

    public void setAutoStopThreshold(int maxReconnectsWithoutEvents) {
        this.maxReconnectsWithoutEvents = maxReconnectsWithoutEvents;
    }

    public int getReconnectsWithoutEvents() {
        return this.reconnectWithoutEvents.get();
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public void setHttpClient(HttpClient client) {
        this.client = client;
    }

    public long getLastEventID() {
        return this.lastEventID;
    }

    public void setLastEventID(long id) {
        this.lastEventID = id;
    }

    public boolean isResetLastEventIDonReconnect() {
        return this.resetEventIDonReconnect;
    }

    public void setResetLastEventIDonReconnect(boolean reset) {
        this.resetEventIDonReconnect = reset;
    }

    public Set<EventStreamListener> getListeners() {
        return new HashSet<EventStreamListener>(this.listeners);
    }

    public synchronized void removeAllListeners() {
        this.listeners.clear();
    }

    public synchronized void addListener(EventStreamListener ... listener) {
        for (EventStreamListener l : listener) {
            if (l == null) continue;
            this.listeners.add(l);
        }
    }

    public synchronized void removeListener(EventStreamListener ... listener) {
        for (EventStreamListener l : listener) {
            if (l == null) continue;
            this.listeners.remove(l);
        }
    }

    public boolean isRunning() {
        return this.running != null && !this.running.isDone();
    }

    public synchronized HttpEventStreamClient start() {
        for (InternalEventStreamAdapter listener : this.internalListeners) {
            try {
                listener.onStartFirst(this.running != null && this.running.isDone() ? this.running.get() : null);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (InternalEventStreamAdapter l : this.internalListeners) {
                    try {
                        l.onError(this, ex);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.running != null) {
            long leid = this.lastEventID;
            if (this.resetEventIDonReconnect) {
                this.lastEventID = 0L;
            }
            for (InternalEventStreamAdapter internalEventStreamAdapter : this.internalListeners) {
                try {
                    internalEventStreamAdapter.onReconnect(this, this.running.isDone() ? this.running.get() : null, this.hasReceivedEvents.get(), leid);
                }
                catch (Exception ex) {
                    for (EventStreamListener eventStreamListener : this.internalListeners) {
                        try {
                            eventStreamListener.onError(this, ex);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            for (EventStreamListener eventStreamListener : this.listeners) {
                try {
                    eventStreamListener.onReconnect(this, this.running.isDone() ? this.running.get() : null, this.hasReceivedEvents.get(), leid);
                }
                catch (Exception ex) {
                    for (EventStreamListener eventStreamListener2 : this.listeners) {
                        try {
                            eventStreamListener2.onError(this, ex);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        this.hasReceivedEvents.set(false);
        if (this.client == null) {
            this.client = HttpClient.newHttpClient();
        }
        HttpRequest.Builder request = HttpRequest.newBuilder(this.uri);
        switch (this.method) {
            case GET: {
                request.GET();
                break;
            }
            case POST: {
                request.POST(this.requestBody);
                break;
            }
            case PUT: {
                request.PUT(this.requestBody);
                break;
            }
            case DELETE: {
                request.DELETE();
                break;
            }
        }
        if (this.version != null) {
            request.version(this.version);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
        request.setHeader("Accept", "text/event-stream");
        request.setHeader("Cache-Control", "no-cache");
        if (this.lastEventID > 0L) {
            request.setHeader("Last-Event-ID", "" + this.lastEventID);
        }
        if (this.timeout >= 0L) {
            request.timeout(Duration.ofMillis(this.timeout));
        }
        for (InternalEventStreamAdapter listener : this.internalListeners) {
            try {
                listener.onStartLast(this.running != null && this.running.isDone() ? this.running.get() : null, request);
            }
            catch (InterruptedException | ExecutionException exception) {}
        }
        this.running = this.client.sendAsync(request.build(), HttpResponse.BodyHandlers.ofByteArrayConsumer(new Consumer<Optional<byte[]>>(){
            StringBuilder sb = new StringBuilder();
            StringBuilder data = new StringBuilder();
            String event = null;

            @Override
            public void accept(Optional<byte[]> t) {
                if (t.isPresent()) {
                    int index;
                    HttpEventStreamClient.this.hasReceivedEvents.set(true);
                    HttpEventStreamClient.this.reconnectWithoutEvents.set(0);
                    this.sb.append(new String(t.get(), StandardCharsets.UTF_8));
                    while ((index = this.sb.indexOf("\n\n")) >= 0) {
                        String[] lines = this.sb.substring(0, index).split("\n");
                        this.sb.delete(0, index + 2);
                        boolean hasDataOrEvent = false;
                        boolean updatedEventID = false;
                        block33: for (String line : lines) {
                            int idx = line.indexOf(58);
                            if (idx <= 0) continue;
                            String string = line.substring(0, idx);
                            String value = line.substring(idx + 1).trim();
                            switch (string.trim().toLowerCase()) {
                                case "event": {
                                    this.event = value;
                                    hasDataOrEvent = true;
                                    continue block33;
                                }
                                case "data": {
                                    if (this.data.length() > 0) {
                                        this.data.append("\n");
                                    }
                                    this.data.append(value);
                                    hasDataOrEvent = true;
                                    continue block33;
                                }
                                case "id": {
                                    try {
                                        HttpEventStreamClient.this.lastEventID = Long.parseLong(value);
                                        updatedEventID = true;
                                        continue block33;
                                    }
                                    catch (Exception ex) {
                                        for (InternalEventStreamAdapter internalEventStreamAdapter : HttpEventStreamClient.this.internalListeners) {
                                            try {
                                                internalEventStreamAdapter.onError(HttpEventStreamClient.this, ex);
                                            }
                                            catch (Exception exception) {}
                                        }
                                        for (EventStreamListener eventStreamListener : HttpEventStreamClient.this.listeners) {
                                            try {
                                                eventStreamListener.onError(HttpEventStreamClient.this, ex);
                                            }
                                            catch (Exception exception) {}
                                        }
                                        continue block33;
                                    }
                                }
                                case "retry": {
                                    try {
                                        HttpEventStreamClient.this.retryCooldown = Long.parseLong(value);
                                        continue block33;
                                    }
                                    catch (Exception ex) {
                                        for (InternalEventStreamAdapter internalEventStreamAdapter : HttpEventStreamClient.this.internalListeners) {
                                            try {
                                                internalEventStreamAdapter.onError(HttpEventStreamClient.this, ex);
                                            }
                                            catch (Exception exception) {}
                                        }
                                        for (EventStreamListener eventStreamListener : HttpEventStreamClient.this.listeners) {
                                            try {
                                                eventStreamListener.onError(HttpEventStreamClient.this, ex);
                                            }
                                            catch (Exception exception) {}
                                        }
                                        continue block33;
                                    }
                                }
                            }
                        }
                        if (!hasDataOrEvent) continue;
                        if (!updatedEventID) {
                            ++HttpEventStreamClient.this.lastEventID;
                        }
                        Event event = new Event(HttpEventStreamClient.this.lastEventID, this.event, this.data.toString());
                        for (InternalEventStreamAdapter listener : HttpEventStreamClient.this.internalListeners) {
                            try {
                                listener.onEvent(HttpEventStreamClient.this, event);
                            }
                            catch (Exception ex) {
                                for (InternalEventStreamAdapter internalEventStreamAdapter : HttpEventStreamClient.this.internalListeners) {
                                    try {
                                        internalEventStreamAdapter.onError(HttpEventStreamClient.this, ex);
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                        for (EventStreamListener listener : HttpEventStreamClient.this.listeners) {
                            try {
                                listener.onEvent(HttpEventStreamClient.this, event);
                            }
                            catch (Exception ex) {
                                for (EventStreamListener eventStreamListener : HttpEventStreamClient.this.listeners) {
                                    try {
                                        eventStreamListener.onError(HttpEventStreamClient.this, ex);
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                        this.data.setLength(0);
                    }
                }
            }
        }));
        this.running.handleAsync(new BiFunction<HttpResponse<Void>, Throwable, Void>(){

            @Override
            public Void apply(HttpResponse<Void> t, Throwable u) {
                if (u != null) {
                    for (InternalEventStreamAdapter internalEventStreamAdapter : HttpEventStreamClient.this.internalListeners) {
                        try {
                            internalEventStreamAdapter.onError(HttpEventStreamClient.this, u);
                        }
                        catch (Exception exception) {}
                    }
                    for (EventStreamListener eventStreamListener : HttpEventStreamClient.this.listeners) {
                        try {
                            eventStreamListener.onError(HttpEventStreamClient.this, u);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!HttpEventStreamClient.this.hasReceivedEvents.get()) {
                    HttpEventStreamClient.this.reconnectWithoutEvents.incrementAndGet();
                }
                if (HttpEventStreamClient.this.maxReconnectsWithoutEvents < 0 || HttpEventStreamClient.this.reconnectWithoutEvents.get() < HttpEventStreamClient.this.maxReconnectsWithoutEvents) {
                    if (HttpEventStreamClient.this.running != null) {
                        if (HttpEventStreamClient.this.retryCooldown > 0L) {
                            try {
                                Thread.sleep(HttpEventStreamClient.this.retryCooldown);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        HttpEventStreamClient.this.start();
                    }
                } else {
                    HttpEventStreamClient.this.stop();
                }
                return null;
            }
        });
        return this;
    }

    public HttpEventStreamClient join() {
        while (this.running != null) {
            try {
                this.running.join();
            }
            catch (Exception exception) {}
        }
        this.lastEventID = 1L;
        return this;
    }

    public synchronized HttpEventStreamClient stop() {
        CompletableFuture<HttpResponse<Void>> run = this.running;
        this.running = null;
        HttpResponse response = null;
        if (run != null) {
            if (run.isDone()) {
                if (!run.isCancelled() && !run.isCompletedExceptionally()) {
                    response = run.getNow(null);
                }
            } else {
                run.cancel(true);
            }
        }
        for (InternalEventStreamAdapter internalEventStreamAdapter : this.internalListeners) {
            try {
                internalEventStreamAdapter.onClose(this, response);
            }
            catch (Exception exception) {}
        }
        for (EventStreamListener eventStreamListener : this.listeners) {
            try {
                eventStreamListener.onClose(this, response);
            }
            catch (Exception exception) {}
        }
        return this;
    }

    protected abstract class InternalEventStreamAdapter
    extends EventStreamAdapter {
        protected InternalEventStreamAdapter() {
        }

        public void onStartFirst(HttpResponse<Void> lastResponse) {
        }

        public void onStartLast(HttpResponse<Void> lastResponse, HttpRequest.Builder builder) {
        }
    }

    public class Event {
        private final long id;
        private final String event;
        private final String data;

        protected Event(long id, String event, String data) {
            this.id = id;
            this.event = event;
            this.data = data;
        }

        public long getID() {
            return this.id;
        }

        public String getEvent() {
            return this.event;
        }

        public String getData() {
            return this.data;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{id=" + this.id + "; event=\"" + this.event + "\"; data=\"" + this.data + "\"}";
        }
    }
}

