/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.config;

import io.quarkiverse.githubapp.runtime.config.PrivateKeyConverter;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.util.Optional;

@ConfigRoot(name="github-app", phase=ConfigPhase.RUN_TIME)
public class GitHubAppRuntimeConfig {
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    Optional<String> appId;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    Optional<String> appName;
    @ConfigItem(defaultValue="false")
    boolean readConfigFilesFromSourceRepository;
    @ConfigItem
    @ConvertWith(value=PrivateKeyConverter.class)
    Optional<PrivateKey> privateKey;
    @ConfigItem(defaultValue="/")
    @ConvertWith(value=TrimmedStringConverter.class)
    String webhookUrlPath;
    @ConfigItem
    Optional<String> webhookSecret;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    Optional<String> credentialsProvider;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    Optional<String> credentialsProviderName;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    Optional<String> webhookProxyUrl;
    @ConfigItem(defaultValue="https://api.github.com")
    @ConvertWith(value=TrimmedStringConverter.class)
    String instanceEndpoint;
    @ConfigItem(defaultValue="${quarkus.github-app.instance-endpoint}")
    @ConvertWith(value=TrimmedStringConverter.class)
    String restApiEndpoint;
    @ConfigItem(defaultValue="${quarkus.github-app.instance-endpoint}/graphql")
    @ConvertWith(value=TrimmedStringConverter.class)
    String graphqlApiEndpoint;
    @ConfigItem
    Debug debug;

    @ConfigGroup
    public static class Debug {
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<Path> payloadDirectory;
    }
}

