/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.error;

import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.error.ErrorHandler;
import io.quarkiverse.githubapp.runtime.github.GitHubServiceDownException;
import io.quarkiverse.githubapp.runtime.github.PayloadHelper;
import io.quarkus.arc.DefaultBean;
import io.quarkus.runtime.LaunchMode;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.ServiceDownException;

@ApplicationScoped
@DefaultBean
public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger LOG = Logger.getLogger((String)GitHubEvent.class.getPackageName());
    private static final String REDELIVERY_URL = "https://github.com/settings/apps/%1$s/advanced";
    @Inject
    LaunchMode launchMode;

    @Override
    public void handleError(GitHubEvent gitHubEvent, GHEventPayload payload, Throwable t) {
        Optional<String> context;
        StringBuilder errorMessage = new StringBuilder();
        ArrayList<String> errorMessageParameters = new ArrayList<String>();
        errorMessage.append("Error handling delivery {").append(errorMessageParameters.size()).append("}\n");
        errorMessageParameters.add(gitHubEvent.getDeliveryId());
        if (t instanceof ServiceDownException || t instanceof GitHubServiceDownException) {
            errorMessage.append("\u203a\u203a\u203a GitHub APIs are not available at the moment. Have a look at https://www.githubstatus.com.\n");
        }
        if (gitHubEvent.getRepository().isPresent()) {
            errorMessage.append("\u203a Repository: {").append(errorMessageParameters.size()).append("}\n");
            errorMessageParameters.add(gitHubEvent.getRepository().get());
        }
        errorMessage.append("\u203a Event:      {").append(errorMessageParameters.size()).append("}\n");
        errorMessageParameters.add(gitHubEvent.getEventAction());
        if (payload != null && (context = PayloadHelper.getContext(payload)).isPresent()) {
            errorMessage.append("\u203a Context:    {").append(errorMessageParameters.size()).append("}\n");
            errorMessageParameters.add(context.get());
        }
        if (gitHubEvent.getAppName().isPresent()) {
            errorMessage.append("\u203a Redeliver:  {").append(errorMessageParameters.size()).append("}\n");
            errorMessageParameters.add(String.format(REDELIVERY_URL, gitHubEvent.getAppName().get()));
        }
        if (this.launchMode.isDevOrTest()) {
            errorMessage.append("\u203a Payload:\n").append("----\n").append("{").append(errorMessageParameters.size()).append("}\n").append("----\n");
            errorMessageParameters.add(gitHubEvent.getParsedPayload().encodePrettily());
        }
        errorMessage.append("Exception");
        LOG.errorv(t, errorMessage.toString(), errorMessageParameters.toArray());
    }
}

