/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.error;

import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.error.ErrorHandler;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHEventPayload;

public class ErrorHandlerBridgeFunction
implements Function<Throwable, Void> {
    private static final Logger LOG = Logger.getLogger(ErrorHandlerBridgeFunction.class);
    private final GitHubEvent gitHubEvent;
    private final GHEventPayload payload;

    public ErrorHandlerBridgeFunction(GitHubEvent gitHubEvent) {
        this.gitHubEvent = gitHubEvent;
        this.payload = null;
    }

    public ErrorHandlerBridgeFunction(GitHubEvent gitHubEvent, GHEventPayload payload) {
        this.gitHubEvent = gitHubEvent;
        this.payload = payload;
    }

    @Override
    public Void apply(Throwable t) {
        InstanceHandle errorHandler = Arc.container().instance(ErrorHandler.class, new Annotation[0]);
        if (errorHandler.isAvailable()) {
            ((ErrorHandler)errorHandler.get()).handleError(this.gitHubEvent, this.payload, t);
        } else {
            LOG.error((Object)"An error occurred and no ErrorHandler is available", t);
        }
        return null;
    }
}

