/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.firestore.runtime;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import io.quarkiverse.googlecloudservices.common.GcpBootstrapConfiguration;
import io.quarkiverse.googlecloudservices.common.GcpConfigHolder;
import io.quarkiverse.googlecloudservices.firestore.runtime.FirestoreConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.threeten.bp.Duration;

@ApplicationScoped
public class FirestoreProducer {
    @Inject
    Instance<Credentials> googleCredentials;
    @Inject
    GcpConfigHolder gcpConfigHolder;
    @Inject
    FirestoreConfiguration firestoreConfiguration;
    @Inject
    GcpBootstrapConfiguration gcpBootstrapConfiguration;

    @Produces
    @Singleton
    @Default
    public Firestore firestore() throws IOException {
        GcpBootstrapConfiguration gcpConfiguration = this.gcpConfigHolder.getBootstrapConfig();
        FirestoreOptions.Builder builder = (FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId((String)gcpConfiguration.projectId().orElse(null));
        if (this.useEmulatorCredentials()) {
            builder.setCredentials((Credentials)new FirestoreOptions.EmulatorCredentials());
            this.firestoreConfiguration.hostOverride.ifPresent(arg_0 -> ((FirestoreOptions.Builder)builder).setEmulatorHost(arg_0));
        } else {
            builder.setCredentials((Credentials)this.googleCredentials.get());
            this.firestoreConfiguration.hostOverride.ifPresent(arg_0 -> ((FirestoreOptions.Builder)builder).setHost(arg_0));
            this.firestoreConfiguration.retry.map(this::buildRetrySettings).ifPresent(arg_0 -> ((FirestoreOptions.Builder)builder).setRetrySettings(arg_0));
            this.firestoreConfiguration.databaseId.ifPresent(arg_0 -> ((FirestoreOptions.Builder)builder).setDatabaseId(arg_0));
        }
        return (Firestore)builder.build().getService();
    }

    private RetrySettings buildRetrySettings(FirestoreConfiguration.RetryConfiguration retryConfiguration) {
        RetrySettings.Builder retrySettingsBuilder = RetrySettings.newBuilder();
        retryConfiguration.totalTimeout.ifPresent(d -> retrySettingsBuilder.setTotalTimeout(this.convertDuration((java.time.Duration)d)));
        retryConfiguration.initialRetryDelay.ifPresent(d -> retrySettingsBuilder.setInitialRetryDelay(this.convertDuration((java.time.Duration)d)));
        retryConfiguration.retryDelayMultiplier.ifPresent(arg_0 -> ((RetrySettings.Builder)retrySettingsBuilder).setRetryDelayMultiplier(arg_0));
        retryConfiguration.maxRetryDelay.ifPresent(d -> retrySettingsBuilder.setMaxRetryDelay(this.convertDuration((java.time.Duration)d)));
        retryConfiguration.maxAttempts.ifPresent(arg_0 -> ((RetrySettings.Builder)retrySettingsBuilder).setMaxAttempts(arg_0));
        retryConfiguration.initialRpcTimeout.ifPresent(d -> retrySettingsBuilder.setInitialRpcTimeout(this.convertDuration((java.time.Duration)d)));
        retryConfiguration.rpcTimeoutMultiplier.ifPresent(arg_0 -> ((RetrySettings.Builder)retrySettingsBuilder).setRpcTimeoutMultiplier(arg_0));
        retryConfiguration.maxRpcTimeout.ifPresent(d -> retrySettingsBuilder.setMaxRpcTimeout(this.convertDuration((java.time.Duration)d)));
        return retrySettingsBuilder.build();
    }

    private Duration convertDuration(java.time.Duration duration) {
        return Duration.ofMillis((long)duration.toMillis());
    }

    private boolean useEmulatorCredentials() {
        return !this.gcpBootstrapConfiguration.accessTokenEnabled() && this.firestoreConfiguration.hostOverride.isPresent() && this.firestoreConfiguration.hostOverride.get().contains("localhost");
    }
}

