/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.pubsub.deployment;

import io.quarkiverse.googlecloudservices.pubsub.deployment.PubSubBuildTimeConfig;
import io.quarkiverse.googlecloudservices.pubsub.deployment.PubSubDevServiceConfig;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.testcontainers.containers.PubSubEmulatorContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class PubSubDevServiceProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)PubSubDevServiceProcessor.class.getName());
    private static volatile DevServicesResultBuildItem.RunningDevService devService;
    private static volatile PubSubDevServiceConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BuildStep
    public DevServicesResultBuildItem start(DockerStatusBuildItem dockerStatusBuildItem, PubSubBuildTimeConfig pubSubBuildTimeConfig, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LaunchModeBuildItem launchMode, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig globalDevServicesConfig) {
        if (devService != null && !pubSubBuildTimeConfig.devservice().equals(config)) {
            this.stopContainer();
        } else if (devService != null) {
            return devService.toBuildItem();
        }
        try (StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Google Cloud PubSub Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);){
            devService = this.startContainerIfAvailable(dockerStatusBuildItem, pubSubBuildTimeConfig.devservice(), globalDevServicesConfig.timeout);
        }
        return devService == null ? null : devService.toBuildItem();
    }

    private DevServicesResultBuildItem.RunningDevService startContainerIfAvailable(DockerStatusBuildItem dockerStatusBuildItem, PubSubDevServiceConfig config, Optional<Duration> timeout) {
        if (!config.enabled()) {
            LOGGER.debug((Object)"Not starting Dev Services for PubSub as it has been disabled in the config");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            LOGGER.warn((Object)"Not starting devservice because docker is not available");
            return null;
        }
        return this.startContainer(dockerStatusBuildItem, config, timeout);
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, PubSubDevServiceConfig config, Optional<Duration> timeout) {
        QuarkusPubSubContainer emulatorContainer = new QuarkusPubSubContainer(DockerImageName.parse((String)config.imageName()).asCompatibleSubstituteFor("gcr.io/google.com/cloudsdktool/cloud-sdk"), config.emulatorPort().orElse(null));
        timeout.ifPresent(arg_0 -> ((PubSubEmulatorContainer)emulatorContainer).withStartupTimeout(arg_0));
        emulatorContainer.start();
        PubSubDevServiceProcessor.config = config;
        return new DevServicesResultBuildItem.RunningDevService("google-cloud-pubsub", emulatorContainer.getContainerId(), () -> ((PubSubEmulatorContainer)emulatorContainer).close(), "quarkus.google.cloud.pubsub.emulator-host", emulatorContainer.getEmulatorEndpoint());
    }

    private void stopContainer() {
        if (devService != null && devService.isOwner()) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Failed to stop pubsub container", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private static class QuarkusPubSubContainer
    extends PubSubEmulatorContainer {
        private final Integer fixedExposedPort;
        private static final int INTERNAL_PORT = 8085;

        private QuarkusPubSubContainer(DockerImageName dockerImageName, Integer fixedExposedPort) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
        }

        public void configure() {
            super.configure();
            if (this.fixedExposedPort != null) {
                this.addFixedExposedPort(this.fixedExposedPort, 8085);
            } else {
                this.addExposedPort(8085);
            }
        }
    }
}

