/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.quarkiverse.googlecloudservices.common.GcpConfigHolder;
import io.quarkiverse.googlecloudservices.pubsub.PubSubConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.StreamSupport;

@ApplicationScoped
public class QuarkusPubSub {
    @Inject
    CredentialsProvider credentialsProvider;
    @Inject
    GcpConfigHolder gcpConfigHolder;
    @Inject
    PubSubConfiguration pubSubConfiguration;
    private Optional<TransportChannelProvider> channelProvider;

    @PostConstruct
    void init() {
        if (this.pubSubConfiguration.emulatorHost().isPresent()) {
            ManagedChannel channel = ManagedChannelBuilder.forTarget((String)this.pubSubConfiguration.emulatorHost().get()).usePlaintext().build();
            this.channelProvider = Optional.of(FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)channel)));
        } else {
            this.channelProvider = Optional.empty();
        }
    }

    @PreDestroy
    void destroy() throws Exception {
        if (this.channelProvider.isPresent()) {
            this.channelProvider.get().getTransportChannel().close();
        }
    }

    public Subscriber subscriber(String subscription, MessageReceiver receiver) {
        return this.subscriber(subscription, (String)this.gcpConfigHolder.getBootstrapConfig().projectId().orElseThrow(), receiver);
    }

    public Subscriber subscriber(String subscription, String projectId, MessageReceiver receiver) {
        ProjectSubscriptionName subscriptionName = ProjectSubscriptionName.of((String)projectId, (String)subscription);
        Subscriber.Builder builder = Subscriber.newBuilder((ProjectSubscriptionName)subscriptionName, (MessageReceiver)receiver).setCredentialsProvider(this.credentialsProvider);
        this.channelProvider.ifPresent(arg_0 -> ((Subscriber.Builder)builder).setChannelProvider(arg_0));
        return builder.build();
    }

    public Publisher publisher(String topic) throws IOException {
        return this.publisher(topic, (String)this.gcpConfigHolder.getBootstrapConfig().projectId().orElseThrow());
    }

    public Publisher publisher(String topic, String projectId) throws IOException {
        TopicName topicName = TopicName.of((String)projectId, (String)topic);
        Publisher.Builder builder = Publisher.newBuilder((TopicName)topicName).setCredentialsProvider(this.credentialsProvider);
        this.channelProvider.ifPresent(arg_0 -> ((Publisher.Builder)builder).setChannelProvider(arg_0));
        return builder.build();
    }

    public SubscriptionAdminSettings subscriptionAdminSettings() throws IOException {
        SubscriptionAdminSettings.Builder builder = (SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider);
        this.channelProvider.ifPresent(arg_0 -> ((SubscriptionAdminSettings.Builder)builder).setTransportChannelProvider(arg_0));
        return builder.build();
    }

    public TopicAdminSettings topicAdminSettings() throws IOException {
        TopicAdminSettings.Builder builder = (TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(this.credentialsProvider);
        this.channelProvider.ifPresent(arg_0 -> ((TopicAdminSettings.Builder)builder).setTransportChannelProvider(arg_0));
        return builder.build();
    }

    public Topic createTopic(String topic) throws IOException {
        TopicAdminSettings topicAdminSettings = this.topicAdminSettings();
        TopicName topicName = TopicName.of((String)((String)this.gcpConfigHolder.getBootstrapConfig().projectId().orElseThrow()), (String)topic);
        try (TopicAdminClient topicAdminClient = TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);){
            Iterable topics = topicAdminClient.listTopics(ProjectName.of((String)((String)this.gcpConfigHolder.getBootstrapConfig().projectId().orElseThrow()))).iterateAll();
            Optional<Topic> existing = StreamSupport.stream(topics.spliterator(), false).filter(top -> top.getName().equals(topicName.toString())).findFirst();
            Topic topic2 = existing.orElseGet(() -> topicAdminClient.createTopic(topicName.toString()));
            return topic2;
        }
    }

    public Subscription createSubscription(String topic, String subscription) throws IOException {
        SubscriptionName subscriptionName = SubscriptionName.of((String)((String)this.gcpConfigHolder.getBootstrapConfig().projectId().orElseThrow()), (String)subscription);
        TopicName topicName = TopicName.of((String)((String)this.gcpConfigHolder.getBootstrapConfig().projectId().orElseThrow()), (String)topic);
        SubscriptionAdminSettings subscriptionAdminSettings = this.subscriptionAdminSettings();
        try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create((SubscriptionAdminSettings)subscriptionAdminSettings);){
            Iterable subscriptions = subscriptionAdminClient.listSubscriptions(ProjectName.of((String)((String)this.gcpConfigHolder.getBootstrapConfig().projectId().orElseThrow()))).iterateAll();
            Optional<Subscription> existing = StreamSupport.stream(subscriptions.spliterator(), false).filter(sub -> sub.getName().equals(subscriptionName.toString())).findFirst();
            Subscription subscription2 = existing.orElseGet(() -> subscriptionAdminClient.createSubscription(subscriptionName, topicName, PushConfig.getDefaultInstance(), 0));
            return subscription2;
        }
    }
}

