/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.secretmanager.runtime;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import io.quarkiverse.googlecloudservices.common.GcpBootstrapConfiguration;
import io.quarkiverse.googlecloudservices.common.GcpConfigHolder;
import io.quarkus.arc.Unremovable;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;

@Singleton
public class SecretManagerProducer {
    @Inject
    GoogleCredentials googleCredentials;
    @Inject
    GcpConfigHolder gcpConfigHolder;

    @Produces
    @Singleton
    @Default
    @Unremovable
    public SecretManagerServiceClient secretManagerClient() throws IOException {
        GcpBootstrapConfiguration gcpConfiguration = this.gcpConfigHolder.getBootstrapConfig();
        SecretManagerServiceSettings.Builder builder = (SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider(() -> this.googleCredentials);
        builder.setQuotaProjectId((String)gcpConfiguration.projectId().orElse(null));
        return SecretManagerServiceClient.create((SecretManagerServiceSettings)builder.build());
    }
}

