/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.secretmanager.runtime.config;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import io.quarkiverse.googlecloudservices.common.GcpBootstrapConfiguration;
import io.quarkiverse.googlecloudservices.secretmanager.runtime.config.SecretManagerConfigUtils;
import io.smallrye.config.common.AbstractConfigSource;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class SecretManagerConfigSource
extends AbstractConfigSource {
    private static final int SECRET_MANAGER_ORDINAL = 50;
    private static final String CONFIG_SOURCE_NAME = "io.quarkiverse.googlecloudservices.secretmanager.runtime.config";
    private final String projectId;
    private final SecretManagerServiceClient client;
    private final AtomicBoolean closed;
    private static final String CLOUD_OAUTH_SCOPE = "https://www.googleapis.com/auth/cloud-platform";

    public SecretManagerConfigSource(GcpBootstrapConfiguration gcpConfig, String projectId) {
        super(CONFIG_SOURCE_NAME, 50);
        this.projectId = projectId;
        if (gcpConfig.secretManagerEnabled()) {
            this.client = SecretManagerConfigSource.createClient(gcpConfig, projectId);
            this.closed = new AtomicBoolean(false);
        } else {
            this.client = null;
            this.closed = new AtomicBoolean(true);
        }
    }

    public String getValue(String propertyName) {
        SecretVersionName secretVersionName = SecretManagerConfigUtils.getSecretVersionName(propertyName, this.projectId);
        if (secretVersionName == null) {
            return null;
        }
        if (!this.closed.get()) {
            AccessSecretVersionResponse response = this.client.accessSecretVersion(secretVersionName);
            return response.getPayload().getData().toStringUtf8();
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        return Collections.emptySet();
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    void closeClient() {
        this.closed.compareAndSet(false, true);
        if (this.client != null) {
            this.client.close();
        }
    }

    private static SecretManagerServiceClient createClient(GcpBootstrapConfiguration gcpConfig, String projectId) {
        try {
            return SecretManagerServiceClient.create((SecretManagerServiceSettings)((SecretManagerServiceSettings.Builder)((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setQuotaProjectId(projectId)).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)SecretManagerConfigSource.credentials(gcpConfig)))).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static GoogleCredentials credentials(GcpBootstrapConfiguration gcpConfig) throws IOException {
        if (gcpConfig.serviceAccountLocation().isPresent()) {
            try (FileInputStream is = new FileInputStream((String)gcpConfig.serviceAccountLocation().get());){
                GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)is).createScoped(new String[]{CLOUD_OAUTH_SCOPE});
                return googleCredentials;
            }
        }
        if (gcpConfig.serviceAccountEncodedKey().isPresent()) {
            byte[] decode = Base64.getDecoder().decode((String)gcpConfig.serviceAccountEncodedKey().get());
            try (ByteArrayInputStream is = new ByteArrayInputStream(decode);){
                GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)is).createScoped(new String[]{CLOUD_OAUTH_SCOPE});
                return googleCredentials;
            }
        }
        return GoogleCredentials.getApplicationDefault().createScoped(new String[]{CLOUD_OAUTH_SCOPE});
    }
}

