/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.secretmanager.runtime.config;

import com.google.cloud.ServiceOptions;
import io.quarkiverse.googlecloudservices.common.GcpBootstrapConfiguration;
import io.quarkiverse.googlecloudservices.secretmanager.runtime.config.SecretManagerConfigSource;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class SecretManagerConfigSourceFactory
implements ConfigSourceFactory {
    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        String projectId;
        SmallRyeConfig config = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigSourceContext.ConfigSourceContextConfigSource(context)}).withMapping(GcpBootstrapConfiguration.class).withMappingIgnore("quarkus.**").build();
        GcpBootstrapConfiguration gcpConfig = (GcpBootstrapConfiguration)config.getConfigMapping(GcpBootstrapConfiguration.class);
        if (gcpConfig.enableMetadataServer() && (projectId = gcpConfig.projectId().orElse(ServiceOptions.getDefaultProjectId())) != null) {
            return Collections.singletonList(new SecretManagerConfigSource(gcpConfig, projectId));
        }
        return Collections.emptyList();
    }
}

