/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.storage.runtime;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import io.quarkiverse.googlecloudservices.common.GcpBootstrapConfiguration;
import io.quarkiverse.googlecloudservices.common.GcpConfigHolder;
import io.quarkiverse.googlecloudservices.storage.runtime.StorageConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;

@ApplicationScoped
public class StorageProducer {
    @Inject
    Instance<Credentials> googleCredentials;
    @Inject
    GcpConfigHolder gcpConfigHolder;
    @Inject
    StorageConfiguration storageConfiguration;

    @Produces
    @Singleton
    @Default
    public Storage storage() throws IOException {
        GcpBootstrapConfiguration gcpConfiguration = this.gcpConfigHolder.getBootstrapConfig();
        NoCredentials credentials = this.storageConfiguration.hostOverride().isPresent() ? NoCredentials.getInstance() : (Credentials)this.googleCredentials.get();
        StorageOptions.Builder builder = (StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)credentials);
        gcpConfiguration.projectId().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setProjectId(arg_0));
        this.storageConfiguration.hostOverride().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setHost(arg_0));
        builder.setTransportOptions(this.transportOptions());
        this.retrySettings().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setRetrySettings(arg_0));
        return (Storage)builder.build().getService();
    }

    private TransportOptions transportOptions() {
        return this.storageConfiguration.transport().useGrpc() != false ? this.grpcTransportOption() : this.httpTransportOptions();
    }

    private TransportOptions httpTransportOptions() {
        HttpTransportOptions.Builder builder = HttpTransportOptions.newBuilder();
        this.storageConfiguration.transport().httpConnectTimeout().ifPresent(arg_0 -> ((HttpTransportOptions.Builder)builder).setConnectTimeout(arg_0));
        this.storageConfiguration.transport().httpReadTimeout().ifPresent(arg_0 -> ((HttpTransportOptions.Builder)builder).setReadTimeout(arg_0));
        return builder.build();
    }

    private TransportOptions grpcTransportOption() {
        GrpcTransportOptions.Builder builder = GrpcTransportOptions.newBuilder();
        return builder.build();
    }

    private Optional<RetrySettings> retrySettings() {
        StorageConfiguration.Retry config = this.storageConfiguration.retry();
        return config.initialRetryDelayMillis().or(config::initialRpcTimeoutMillis).or(config::logicalTimeoutMillis).or(config::maxAttempts).or(config::maxRpcTimeoutMillis).or(config::maxRetryDelayMillis).or(config::totalTimeoutMillis).map(o -> {
            RetrySettings.Builder builder = RetrySettings.newBuilder();
            config.initialRetryDelayMillis().map(this::toDuration).ifPresent(arg_0 -> ((RetrySettings.Builder)builder).setInitialRetryDelayDuration(arg_0));
            config.maxRetryDelayMillis().map(this::toDuration).ifPresent(arg_0 -> ((RetrySettings.Builder)builder).setMaxRetryDelayDuration(arg_0));
            config.initialRpcTimeoutMillis().map(this::toDuration).ifPresent(arg_0 -> ((RetrySettings.Builder)builder).setInitialRpcTimeoutDuration(arg_0));
            config.maxRpcTimeoutMillis().map(this::toDuration).ifPresent(arg_0 -> ((RetrySettings.Builder)builder).setMaxRpcTimeoutDuration(arg_0));
            config.logicalTimeoutMillis().map(this::toDuration).ifPresent(arg_0 -> ((RetrySettings.Builder)builder).setLogicalTimeout(arg_0));
            config.totalTimeoutMillis().map(this::toDuration).ifPresent(arg_0 -> ((RetrySettings.Builder)builder).setTotalTimeoutDuration(arg_0));
            config.maxAttempts().ifPresent(arg_0 -> ((RetrySettings.Builder)builder).setMaxAttempts(arg_0));
            return builder.build();
        });
    }

    private Duration toDuration(Integer integer) {
        return Duration.ofMillis(integer.intValue());
    }

    public void close(@Disposes Storage storage) throws Exception {
        storage.close();
    }
}

