/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.googlecloudservices.storage.runtime;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import io.quarkiverse.googlecloudservices.common.GcpBootstrapConfiguration;
import io.quarkiverse.googlecloudservices.common.GcpConfigHolder;
import io.quarkiverse.googlecloudservices.storage.runtime.StorageConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;

@ApplicationScoped
public class StorageProducer {
    @Inject
    GoogleCredentials googleCredentials;
    @Inject
    GcpConfigHolder gcpConfigHolder;
    @Inject
    StorageConfiguration storageConfiguration;

    @Produces
    @Singleton
    @Default
    public Storage storage() throws IOException {
        GcpBootstrapConfiguration gcpConfiguration = this.gcpConfigHolder.getBootstrapConfig();
        StorageOptions.Builder builder = (StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)this.googleCredentials)).setProjectId((String)gcpConfiguration.projectId().orElse(null));
        this.storageConfiguration.hostOverride.ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setHost(arg_0));
        return (Storage)builder.build().getService();
    }
}

