/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.groovy.deployment;

import groovy.lang.Closure;
import io.quarkiverse.groovy.runtime.GroovyRecorder;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.jackson.spi.ClassPathJacksonModuleBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class GroovyProcessor {
    private static final String FEATURE = "groovy";
    private static final String GROOVY_JACKSON_MODULE = "com.fasterxml.jackson.module.groovy.GroovyModule";
    private static final String DGM_FORMAT_NAME = "org.codehaus.groovy.runtime.dgm$%d";

    GroovyProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerGroovyJacksonModule(BuildProducer<ClassPathJacksonModuleBuildItem> classPathJacksonModules) {
        if (!QuarkusClassLoader.isClassPresentAtRuntime((String)GROOVY_JACKSON_MODULE)) {
            return;
        }
        classPathJacksonModules.produce((BuildItem)new ClassPathJacksonModuleBuildItem(GROOVY_JACKSON_MODULE));
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void registerGroovyReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        String name;
        IndexView index = combinedIndex.getIndex();
        String[] closureClasses = (String[])index.getAllKnownSubclasses(DotName.createSimple(Closure.class)).stream().map(classInfo -> classInfo.name().toString()).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])closureClasses).methods().build());
        ArrayList<String> dgmClassNames = new ArrayList<String>();
        int i = 0;
        while (QuarkusClassLoader.isClassPresentAtRuntime((String)(name = String.format(DGM_FORMAT_NAME, i)))) {
            dgmClassNames.add(name);
            ++i;
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])dgmClassNames.toArray(new String[0])).build());
    }

    @BuildStep(onlyIf={NativeBuild.class})
    List<NativeImageProxyDefinitionBuildItem> registerProxies() {
        ArrayList<NativeImageProxyDefinitionBuildItem> proxies = new ArrayList<NativeImageProxyDefinitionBuildItem>();
        proxies.add(new NativeImageProxyDefinitionBuildItem(new String[]{Function.class.getName()}));
        proxies.add(new NativeImageProxyDefinitionBuildItem(new String[]{Consumer.class.getName()}));
        proxies.add(new NativeImageProxyDefinitionBuildItem(new String[]{Predicate.class.getName()}));
        proxies.add(new NativeImageProxyDefinitionBuildItem(new String[]{Supplier.class.getName()}));
        proxies.add(new NativeImageProxyDefinitionBuildItem(new String[]{BiFunction.class.getName()}));
        proxies.add(new NativeImageProxyDefinitionBuildItem(new String[]{BiConsumer.class.getName()}));
        proxies.add(new NativeImageProxyDefinitionBuildItem(new String[]{BiPredicate.class.getName()}));
        return proxies;
    }

    @BuildStep(onlyIf={IsTest.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem initExtensionModules(GroovyRecorder recorder) {
        recorder.initExtensionModules();
        return new ServiceStartBuildItem("Groovy Extension Module Loader");
    }
}

