/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.groovy.deployment;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovySystem;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.paths.PathCollection;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.jboss.logging.Logger;

public class GroovyCompilationProvider
implements CompilationProvider {
    private static final Logger log = Logger.getLogger(GroovyCompilationProvider.class);
    private static final String GROOVY_PROVIDER_KEY = "groovy";
    private static final Pattern OPTION_PATTERN = Pattern.compile("([^=]+)=(.*)");

    public String getProviderKey() {
        return GROOVY_PROVIDER_KEY;
    }

    public Set<String> handledExtensions() {
        return Set.of(".groovy");
    }

    public void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        CompilerConfiguration cc = GroovyCompilationProvider.getCompilerConfiguration(context);
        cc.setSourceEncoding(context.getSourceEncoding().name());
        cc.setTargetBytecode(context.getTargetJvmVersion());
        cc.setTargetDirectory(context.getOutputDirectory().getAbsolutePath());
        try (URLClassLoader parent = GroovyCompilationProvider.createNewClassLoader(Stream.of(Set.of(cc.getTargetDirectory()), context.getClasspath(), context.getReloadableClasspath()).flatMap(Collection::stream).collect(Collectors.toList()));
             GroovyClassLoader groovyClassLoader = new GroovyClassLoader((ClassLoader)parent, cc);
             GroovyClassLoader transformLoader = new GroovyClassLoader((ClassLoader)parent);){
            CompilationUnit unit = new CompilationUnit(cc, null, groovyClassLoader, transformLoader);
            filesToCompile.forEach(arg_0 -> ((CompilationUnit)unit).addSource(arg_0));
            unit.compile();
            List classes = unit.getClasses();
            log.infof("Compiled %d file%s.", (Object)classes.size(), (Object)(classes.size() > 1 ? "s" : ""));
        }
        catch (CompilationFailedException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static CompilerConfiguration getCompilerConfiguration(CompilationProvider.Context context) {
        CompilerConfiguration cc;
        Set compilerOptions = context.getCompilerOptions(GROOVY_PROVIDER_KEY);
        if (compilerOptions != null && !compilerOptions.isEmpty()) {
            Properties properties = new Properties(compilerOptions.size());
            for (String rawOption : compilerOptions) {
                Matcher matcher = OPTION_PATTERN.matcher(rawOption);
                if (!matcher.matches()) {
                    log.warnf("Groovy compiler option %s is invalid", (Object)rawOption);
                }
                properties.setProperty(matcher.group(1), matcher.group(2));
            }
            cc = new CompilerConfiguration(properties);
        } else {
            cc = new CompilerConfiguration();
        }
        return cc;
    }

    private static URLClassLoader createNewClassLoader(List<File> classpath) throws MalformedURLException {
        ArrayList<URL> urlsList = new ArrayList<URL>();
        for (File file : classpath) {
            urlsList.add(file.toURI().toURL());
        }
        return new URLClassLoader(urlsList.toArray(new URL[0]), GroovySystem.class.getClassLoader());
    }

    public Path getSourcePath(Path classFilePath, PathCollection sourcePaths, String classesPath) {
        return classFilePath;
    }
}

