/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.groovy.runtime;

import groovy.lang.GroovySystem;
import io.quarkus.runtime.annotations.Recorder;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.util.URLStreams;
import org.jboss.logging.Logger;

@Recorder
public class GroovyRecorder {
    private static final Logger LOG = Logger.getLogger(GroovyRecorder.class);

    public void initExtensionModules() {
        if (GroovySystem.getMetaClassRegistry() instanceof MetaClassRegistryImpl) {
            GroovyRecorder.scanModulesFrom("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule");
            GroovyRecorder.scanModulesFrom("META-INF/services/org.codehaus.groovy.runtime.ExtensionModule");
        }
    }

    private static void scanModulesFrom(String moduleMetaInfFile) {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(moduleMetaInfFile);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                GroovyRecorder.scanExtensionModuleFromMetaInf(url);
            }
        }
        catch (Exception e) {
            LOG.warnf("An error occurred while scanning the extension modules '%s': %s", (Object)moduleMetaInfFile, (Object)e.getMessage());
        }
    }

    private static void scanExtensionModuleFromMetaInf(URL metadata) {
        try (InputStream inStream = URLStreams.openUncachedStream((URL)metadata);){
            Properties properties = new Properties();
            properties.load(inStream);
            GroovyRecorder.registerExtensionModuleFromProperties(properties);
        }
        catch (Exception e) {
            LOG.warnf("An error occurred while registering the extension module '%s': %s", (Object)metadata, (Object)e.getMessage());
        }
    }

    private static void registerExtensionModuleFromProperties(Properties properties) {
        HashMap metaMethods = new HashMap();
        MetaClassRegistryImpl registry = (MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry();
        registry.registerExtensionModuleFromProperties(properties, Thread.currentThread().getContextClassLoader(), metaMethods);
        for (Map.Entry entry : metaMethods.entrySet()) {
            CachedClass c = (CachedClass)entry.getKey();
            HashSet<CachedClass> classesToBeUpdated = new HashSet<CachedClass>();
            classesToBeUpdated.add(c);
            ClassInfo.onAllClassInfo(info -> {
                if (c.getTheClass().isAssignableFrom(info.getCachedClass().getTheClass())) {
                    classesToBeUpdated.add(info.getCachedClass());
                }
            });
            classesToBeUpdated.forEach(cc -> cc.addNewMopMethods((List)entry.getValue()));
        }
    }
}

