/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment;

import io.dekorate.ConfigReference;
import io.dekorate.Session;
import io.dekorate.helm.config.HelmChartConfigBuilder;
import io.dekorate.helm.config.HelmChartConfigFluent;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.project.Project;
import io.quarkiverse.helm.deployment.DisableDefaultHelmListener;
import io.quarkiverse.helm.deployment.HelmChartConfig;
import io.quarkiverse.helm.deployment.HelmChartUploader;
import io.quarkiverse.helm.deployment.HelmDependencyConfig;
import io.quarkiverse.helm.deployment.HelmEnabled;
import io.quarkiverse.helm.deployment.QuarkusHelmWriterSessionListener;
import io.quarkiverse.helm.deployment.ValueReferenceConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.DekorateOutputBuildItem;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class HelmProcessor {
    private static final String NAME_FORMAT_REG_EXP = "[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*";
    private static final String QUARKUS_KUBERNETES_NAME = "quarkus.kubernetes.name";
    private static final String QUARKUS_KNATIVE_NAME = "quarkus.knative.name";
    private static final String QUARKUS_OPENSHIFT_NAME = "quarkus.openshift.name";
    private static final String QUARKUS_CONTAINER_IMAGE_NAME = "quarkus.container-image.name";
    private static final String SERVICE_NAME_PLACEHOLDER = "::service-name";
    private static final String SERVICE_PORT_PLACEHOLDER = "::service-port";
    private static final String SERVICE_SPLIT = ":";

    @BuildStep(onlyIf={HelmEnabled.class, IsNormal.class})
    void configureHelmDependencyOrder(Capabilities capabilities, ApplicationInfoBuildItem info, HelmChartConfig config, BuildProducer<DecoratorBuildItem> decorators) {
        if (config.dependencies == null || config.dependencies.isEmpty()) {
            return;
        }
        for (HelmDependencyConfig dependency : config.dependencies.values()) {
            if (!dependency.waitForService.isPresent()) continue;
            ContainerBuilder container = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("wait-for-" + dependency.name)).withImage(dependency.waitForServiceImage)).withCommand(new String[]{"sh"});
            String service = dependency.waitForService.get();
            if (service.contains(SERVICE_SPLIT)) {
                String[] parts = service.split(SERVICE_SPLIT);
                String serviceName = parts[0];
                String servicePort = parts[1];
                container.withArguments(new String[]{"-c", dependency.waitForServicePortCommandTemplate.replaceAll(SERVICE_NAME_PLACEHOLDER, serviceName).replaceAll(SERVICE_PORT_PLACEHOLDER, servicePort)});
            } else {
                container.withArguments(new String[]{"-c", dependency.waitForServiceOnlyCommandTemplate.replaceAll(SERVICE_NAME_PLACEHOLDER, service)});
            }
            decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddInitContainerDecorator(HelmProcessor.getDeploymentName(capabilities, info), (Container)container.build())));
        }
    }

    @BuildStep(onlyIf={HelmEnabled.class, IsNormal.class})
    void generateResources(ApplicationInfoBuildItem app, OutputTargetBuildItem outputTarget, DekorateOutputBuildItem dekorateOutput, List<GeneratedKubernetesResourceBuildItem> generatedResources, BuildProducer<ArtifactResultBuildItem> dummy, HelmChartConfig config) {
        this.validate(config);
        Project project = (Project)dekorateOutput.getProject();
        Path inputFolder = this.getInputDirectory(config, project);
        Path outputFolder = this.getOutputDirectory(config, outputTarget);
        QuarkusHelmWriterSessionListener helmWriter = new QuarkusHelmWriterSessionListener();
        Map<String, Set<File>> deploymentTargets = this.toDeploymentTargets(dekorateOutput.getGeneratedFiles(), generatedResources);
        io.dekorate.helm.config.HelmChartConfig dekorateHelmChartConfig = this.toDekorateHelmChartConfig(app, config);
        List<ConfigReference> valueReferencesFromConfig = this.toValueReferences(config);
        String deploymentTargetToPush = this.deductDeploymentTarget(config, deploymentTargets);
        for (Map.Entry<String, Set<File>> filesInDeploymentTarget : deploymentTargets.entrySet()) {
            String deploymentTarget = filesInDeploymentTarget.getKey();
            Path chartOutputFolder = outputFolder.resolve(deploymentTarget);
            this.deleteOutputHelmFolderIfExists(chartOutputFolder);
            Map<String, String> generated = helmWriter.writeHelmFiles((Session)dekorateOutput.getSession(), project, dekorateHelmChartConfig, valueReferencesFromConfig, config.expressions.values(), config.tarFileClassifier, inputFolder, chartOutputFolder, (Collection<File>)filesInDeploymentTarget.getValue());
            if (!config.repository.push || !deploymentTargetToPush.equals(deploymentTarget)) continue;
            String tarball = generated.keySet().stream().filter(file -> file.endsWith(config.extension)).findFirst().orElseThrow(() -> new RuntimeException("Couldn't find the tarball file. There should have been generated when pushing to a Helm repository is enabled."));
            HelmChartUploader.pushToHelmRepository(new File(tarball), config.repository);
        }
    }

    @BuildStep(onlyIf={HelmEnabled.class, IsNormal.class})
    void disableDefaultHelmListener(BuildProducer<ConfiguratorBuildItem> helmConfiguration) {
        helmConfiguration.produce((BuildItem)new ConfiguratorBuildItem((Object)new DisableDefaultHelmListener()));
    }

    private void validate(HelmChartConfig config) {
        if (config.name.isPresent() && !config.name.get().matches(NAME_FORMAT_REG_EXP)) {
            throw new IllegalStateException(String.format("Wrong name '%s'. Regular expression used for validation is '%s'", config.name.get(), NAME_FORMAT_REG_EXP));
        }
    }

    private String deductDeploymentTarget(HelmChartConfig config, Map<String, Set<File>> deploymentTargets) {
        if (config.repository.push) {
            if (config.repository.deploymentTarget.isPresent()) {
                return config.repository.deploymentTarget.get();
            }
            List deploymentTargetNames = deploymentTargets.keySet().stream().collect(Collectors.toList());
            if (deploymentTargetNames.size() == 1) {
                return (String)deploymentTargetNames.get(0);
            }
            throw new IllegalStateException("Multiple deployment target found: '" + deploymentTargetNames.stream().collect(Collectors.joining(", ")) + "'. To push the Helm Chart to the repository, you need to select only one using the property `quarkus.helm.repository.deployment-target`");
        }
        return null;
    }

    private void deleteOutputHelmFolderIfExists(Path outputFolder) {
        try {
            FileUtil.deleteIfExists((Path)outputFolder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Path getInputDirectory(HelmChartConfig config, Project project) {
        Path path = Paths.get(config.inputDirectory, new String[0]);
        if (!path.isAbsolute()) {
            return project.getRoot().resolve(path);
        }
        return path;
    }

    private Path getOutputDirectory(HelmChartConfig config, OutputTargetBuildItem outputTarget) {
        Path path = Paths.get(config.outputDirectory, new String[0]);
        if (!path.isAbsolute()) {
            return outputTarget.getOutputDirectory().resolve(path);
        }
        return path;
    }

    private Map<String, Set<File>> toDeploymentTargets(List<String> generatedFiles, List<GeneratedKubernetesResourceBuildItem> generatedResources) {
        HashMap<String, Set<File>> filesByDeploymentTarget = new HashMap<String, Set<File>>();
        for (String generatedFile : generatedFiles) {
            File file;
            String deploymentTarget;
            if (generatedFile.toLowerCase(Locale.ROOT).endsWith(".json") || filesByDeploymentTarget.containsKey(deploymentTarget = (file = new File(generatedFile)).getName().substring(0, file.getName().indexOf(".")))) continue;
            HashSet<File> files = new HashSet<File>();
            if (!file.exists()) {
                Optional<byte[]> content = generatedResources.stream().filter(resource -> file.getName().equals(resource.getName())).map(GeneratedKubernetesResourceBuildItem::getContent).findFirst();
                if (content.isPresent()) {
                    try {
                        File tempFile = File.createTempFile("tmp", file.getName());
                        tempFile.deleteOnExit();
                        Files.write(tempFile.toPath(), content.get(), new OpenOption[0]);
                        files.add(tempFile);
                    }
                    catch (IOException ignored) {
                        files.add(file);
                    }
                }
            } else {
                files.add(file);
            }
            filesByDeploymentTarget.put(deploymentTarget, files);
        }
        return filesByDeploymentTarget;
    }

    private io.dekorate.helm.config.HelmChartConfig toDekorateHelmChartConfig(ApplicationInfoBuildItem app, HelmChartConfig config) {
        HelmChartConfigBuilder builder = (HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)new HelmChartConfigBuilder().withEnabled(Boolean.valueOf(config.enabled))).withApiVersion(config.apiVersion)).withName(config.name.orElse(app.getName()))).withCreateTarFile(Boolean.valueOf(config.createTarFile || config.repository.push))).withVersion(config.version.orElse(app.getVersion()))).withExtension(config.extension)).withValuesRootAlias(config.valuesRootAlias)).withNotes(config.notes);
        config.description.ifPresent(arg_0 -> ((HelmChartConfigBuilder)builder).withDescription(arg_0));
        config.keywords.ifPresent(arg_0 -> ((HelmChartConfigBuilder)builder).addAllToKeywords(arg_0));
        config.icon.ifPresent(arg_0 -> ((HelmChartConfigBuilder)builder).withIcon(arg_0));
        config.home.ifPresent(arg_0 -> ((HelmChartConfigBuilder)builder).withHome(arg_0));
        config.sources.ifPresent(arg_0 -> ((HelmChartConfigBuilder)builder).addAllToSources(arg_0));
        config.maintainers.values().forEach(m -> builder.addNewMaintainer(m.name, this.defaultString(m.email), this.defaultString(m.url)));
        config.dependencies.values().forEach(d -> ((HelmChartConfigFluent.DependenciesNested)((HelmChartConfigFluent.DependenciesNested)((HelmChartConfigFluent.DependenciesNested)((HelmChartConfigFluent.DependenciesNested)((HelmChartConfigFluent.DependenciesNested)((HelmChartConfigFluent.DependenciesNested)builder.addNewDependency().withName(d.name)).withAlias(this.defaultString(d.alias, d.name))).withVersion(d.version)).withRepository(d.repository)).withCondition(this.defaultString(d.condition))).withTags(HelmProcessor.defaultArray(d.tags))).endDependency());
        return builder.build();
    }

    private List<ConfigReference> toValueReferences(HelmChartConfig config) {
        return config.values.values().stream().map(v -> new ConfigReference(v.property, HelmProcessor.defaultArray(v.paths), this.toValue((ValueReferenceConfig)v), this.defaultString(v.expression), this.defaultString(v.profile))).collect(Collectors.toList());
    }

    private Object toValue(ValueReferenceConfig v) {
        if (v.valueAsInt.isPresent()) {
            return v.valueAsInt.get();
        }
        if (v.valueAsBool.isPresent()) {
            return v.valueAsBool.get();
        }
        return v.value.orElse(null);
    }

    private String defaultString(Optional<String> value) {
        return this.defaultString(value, null);
    }

    private String defaultString(Optional<String> value, String defaultStr) {
        if (value.isEmpty() || StringUtils.isEmpty((CharSequence)value.get())) {
            return defaultStr;
        }
        return value.get();
    }

    private static String[] defaultArray(Optional<List<String>> optional) {
        return optional.map(l -> l.toArray(new String[0])).orElse(new String[0]);
    }

    public static String getDeploymentName(Capabilities capabilities, ApplicationInfoBuildItem info) {
        Config config = ConfigProvider.getConfig();
        Optional resourceName = capabilities.isPresent("io.quarkus.openshift") ? config.getOptionalValue(QUARKUS_OPENSHIFT_NAME, String.class) : config.getOptionalValue(QUARKUS_KNATIVE_NAME, String.class).or(() -> config.getOptionalValue(QUARKUS_KUBERNETES_NAME, String.class));
        return resourceName.or(() -> config.getOptionalValue(QUARKUS_CONTAINER_IMAGE_NAME, String.class)).orElse(info.getName());
    }
}

