/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment;

import io.dekorate.utils.Strings;
import io.quarkiverse.helm.deployment.HelmProcessor;
import io.quarkiverse.helm.deployment.HelmRepository;
import io.quarkiverse.helm.deployment.HelmRepositoryType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

public final class HelmChartUploader {
    private static Logger LOGGER = Logger.getLogger(HelmProcessor.class);
    private static String APPLICATION_GZIP = "application/gzip";
    private static final String CONTENT_TYPE = "Content-Type";
    private static String POST = "POST";
    private static String PUT = "PUT";

    private HelmChartUploader() {
    }

    static void pushToHelmRepository(File tarball, HelmRepository helmRepository) {
        HelmChartUploader.validate(helmRepository);
        try {
            LOGGER.info((Object)("Pushing the Helm Chart at '" + tarball.getName() + "' to the repository: " + helmRepository.url.get()));
            HttpURLConnection connection = HelmChartUploader.deductConnectionByRepositoryType(tarball, helmRepository);
            HelmChartUploader.writeFileOnConnection(tarball, connection);
            if (connection.getResponseCode() >= 300) {
                String response = connection.getErrorStream() != null ? HelmChartUploader.inputStreamToString(connection.getErrorStream(), Charset.defaultCharset()) : (connection.getInputStream() != null ? HelmChartUploader.inputStreamToString(connection.getInputStream(), Charset.defaultCharset()) : "No details provided");
                throw new RuntimeException("Couldn't upload the Helm chart to the Helm repository: " + response);
            }
            LOGGER.info((Object)"Helm chart was successfully uploaded to the Helm repository.");
            connection.disconnect();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void validate(HelmRepository repository) {
        if (repository.url.isEmpty() || Strings.isNullOrEmpty((String)repository.url.get())) {
            throw new RuntimeException("The push to a Helm repository is enabled (the property `quarkus.helm.repository.push` is true), but the repository URL was not provided (the property `quarkus.helm.repository.url`).");
        }
        if (repository.type.isEmpty()) {
            throw new RuntimeException("The push to a Helm repository is enabled (the property `quarkus.helm.repository.push` is true), but the repository type was not provided (the property `quarkus.helm.repository.type`).");
        }
        if (Strings.isNotNullOrEmpty((String)repository.getUsername()) && Strings.isNullOrEmpty((String)repository.getPassword()) || Strings.isNotNullOrEmpty((String)repository.getPassword()) && Strings.isNullOrEmpty((String)repository.getUsername())) {
            throw new RuntimeException("The push to a Helm repository is enabled (the property `quarkus.helm.repository.push` is true), but either the username (the property `quarkus.helm.repository.username`) or the password (the property `quarkus.helm.repository.password`) was not set.");
        }
    }

    private static void writeFileOnConnection(File file, HttpURLConnection connection) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            HelmChartUploader.copyToOutputStream(fileInputStream, connection.getOutputStream());
        }
    }

    private static HttpURLConnection deductConnectionByRepositoryType(File tarball, HelmRepository repository) throws IOException {
        if (repository.type.get() == HelmRepositoryType.NEXUS) {
            String url = HelmChartUploader.formatRepositoryURL(tarball, repository);
            if (url.endsWith(".tar.gz")) {
                url = url.replaceAll("tar.gz$", "tgz");
            }
            HttpURLConnection connection = HelmChartUploader.createConnection(repository, url);
            connection.setRequestMethod(PUT);
            return connection;
        }
        if (repository.type.get() == HelmRepositoryType.ARTIFACTORY) {
            HttpURLConnection connection = HelmChartUploader.createConnection(repository, HelmChartUploader.formatRepositoryURL(tarball, repository));
            connection.setRequestMethod(PUT);
            return connection;
        }
        return HelmChartUploader.createConnection(repository, repository.url.get());
    }

    private static String formatRepositoryURL(File file, HelmRepository repository) {
        return String.format("%s%s", StringUtils.appendIfMissing((String)repository.url.get(), (CharSequence)"/", (CharSequence[])new CharSequence[0]), file.getName());
    }

    private static HttpURLConnection createConnection(HelmRepository repository, String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod(POST);
        connection.setRequestProperty(CONTENT_TYPE, APPLICATION_GZIP);
        HelmChartUploader.verifyAndSetAuthentication(repository);
        return connection;
    }

    private static void verifyAndSetAuthentication(HelmRepository helmRepository) {
        if (Strings.isNotNullOrEmpty((String)helmRepository.getUsername()) && Strings.isNotNullOrEmpty((String)helmRepository.getPassword())) {
            final PasswordAuthentication authentication = new PasswordAuthentication(helmRepository.getUsername(), helmRepository.getPassword().toCharArray());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return authentication;
                }
            });
        }
    }

    private static String inputStreamToString(InputStream input, Charset charset) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                sb.append((char)c);
            }
        }
        return sb.toString();
    }

    private static void copyToOutputStream(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) != -1) {
            target.write(buf, 0, length);
        }
    }
}

