/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment.decorators;

import io.dekorate.ConfigReference;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import java.util.Arrays;
import java.util.List;

public class LowPriorityAddEnvVarDecorator
extends AddEnvVarDecorator {
    private final String name;
    private final String value;

    public LowPriorityAddEnvVarDecorator(Env env) {
        this(ANY, env.getName(), env.getValue());
    }

    public LowPriorityAddEnvVarDecorator(String deploymentName, String name, String value) {
        super(deploymentName, deploymentName, (Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(name)).withValue(value)).build());
        this.name = name;
        this.value = value;
    }

    public Class<? extends Decorator>[] before() {
        return new Class[]{AddEnvVarDecorator.class};
    }

    public List<ConfigReference> getConfigReferences() {
        return Arrays.asList(this.buildConfigReferenceForEnvValue());
    }

    private ConfigReference buildConfigReferenceForEnvValue() {
        String property = ConfigReference.joinProperties((String[])new String[]{"envs." + this.name});
        String envFilter = ".env.(name == " + this.name + ").value";
        String path = "(metadata.name == " + this.getDeploymentName() + ").spec.template.spec.containers.(name == " + this.getContainerName() + ")" + envFilter;
        return new ConfigReference.Builder(property, path).withValue((Object)this.value).build();
    }
}

