/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment.utils;

import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.HelmDependency;
import io.dekorate.utils.Strings;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class HelmConfigUtils {
    private static final String ROOTLESS_PROPERTY = "@.";

    private HelmConfigUtils() {
    }

    public static String deductProperty(HelmChartConfig helmConfig, String property) {
        String prefix;
        if (((String)property).startsWith(ROOTLESS_PROPERTY)) {
            return ((String)property).replaceFirst(Pattern.quote(ROOTLESS_PROPERTY), "");
        }
        if (!HelmConfigUtils.startWithDependencyPrefix((String)property, helmConfig.getDependencies()) && !((String)property).startsWith(prefix = helmConfig.getValuesRootAlias() + ".")) {
            property = prefix + (String)property;
        }
        return property;
    }

    private static boolean startWithDependencyPrefix(String property, HelmDependency[] dependencies) {
        if (dependencies == null || dependencies.length == 0) {
            return false;
        }
        String[] parts = property.split(Pattern.quote("."));
        if (parts.length <= 1) {
            return false;
        }
        String name = parts[0];
        return Stream.of(dependencies).map(d -> Strings.defaultIfEmpty((String)d.getAlias(), (String)d.getName())).anyMatch(d -> Strings.equals((String)d, (String)name));
    }
}

