/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment.utils;

import io.github.yamlpath.YamlExpressionParser;
import java.util.Set;
import java.util.regex.Pattern;

public final class YamlExpressionParserUtils {
    public static final String SEPARATOR_TOKEN = ":LINE_SEPARATOR:";
    public static final String SEPARATOR_QUOTES = ":DOUBLE_QUOTES";
    public static final String START_EXPRESSION_TOKEN = ":START:";
    public static final String END_EXPRESSION_TOKEN = ":END:";

    private YamlExpressionParserUtils() {
    }

    public static void set(YamlExpressionParser parser, String path, String expression) {
        parser.write(path, (Object)YamlExpressionParserUtils.adaptExpression(expression));
    }

    public static Object read(YamlExpressionParser parser, String path) {
        Set found = parser.read(path);
        return found.stream().findFirst().orElse(null);
    }

    public static Object readAndSet(YamlExpressionParser parser, String path, String expression) {
        Set found = parser.readAndReplace(path, (Object)YamlExpressionParserUtils.adaptExpression(expression));
        return found.stream().findFirst().orElse(null);
    }

    private static String adaptExpression(String expression) {
        return START_EXPRESSION_TOKEN + expression.replaceAll(Pattern.quote(System.lineSeparator()), SEPARATOR_TOKEN).replaceAll(Pattern.quote("\""), SEPARATOR_QUOTES) + END_EXPRESSION_TOKEN;
    }
}

