/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment.utils;

import io.quarkiverse.helm.deployment.HelmChartConfig;
import io.quarkiverse.helm.deployment.HelmDependencyConfig;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class HelmConfigUtils {
    private static final String ROOTLESS_PROPERTY = "@.";

    private HelmConfigUtils() {
    }

    public static String deductProperty(HelmChartConfig helmConfig, String property) {
        return HelmConfigUtils.deductProperty(helmConfig.valuesRootAlias(), helmConfig.dependencies().entrySet().stream().map(entry -> ((HelmDependencyConfig)entry.getValue()).alias().orElseGet(() -> ((HelmDependencyConfig)entry.getValue()).name().orElse((String)entry.getKey()))).collect(Collectors.toList()), property);
    }

    private static String deductProperty(String valuesRootAlias, List<String> dependencies, String property) {
        String prefix;
        if (((String)property).startsWith(ROOTLESS_PROPERTY)) {
            return ((String)property).replaceFirst(Pattern.quote(ROOTLESS_PROPERTY), "");
        }
        if (!HelmConfigUtils.startWithDependencyPrefix((String)property, dependencies) && !((String)property).startsWith(prefix = valuesRootAlias + ".")) {
            property = prefix + (String)property;
        }
        return property;
    }

    private static boolean startWithDependencyPrefix(String property, List<String> dependencies) {
        if (dependencies == null || dependencies.isEmpty()) {
            return false;
        }
        String[] parts = property.split(Pattern.quote("."));
        if (parts.length <= 1) {
            return false;
        }
        String name = parts[0];
        return dependencies.stream().anyMatch(d -> Objects.equals(d, name));
    }
}

