/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment.decorators;

import io.dekorate.ConfigReference;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import java.util.Arrays;
import java.util.List;

public class LowPriorityAddEnvVarDecorator
extends AddEnvVarDecorator {
    private final String name;
    private final String value;

    public LowPriorityAddEnvVarDecorator(String deploymentName, String name, String value) {
        this(deploymentName, deploymentName, name, value);
    }

    public LowPriorityAddEnvVarDecorator(String deployment, String container, String name, String value) {
        super(deployment, container, (Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(name)).withValue(value)).build());
        this.name = name;
        this.value = value;
    }

    public Class<? extends Decorator>[] before() {
        return new Class[]{AddEnvVarDecorator.class};
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class, AddSidecarDecorator.class, AddInitContainerDecorator.class};
    }

    public List<ConfigReference> getConfigReferences() {
        return Arrays.asList(this.buildConfigReferenceForContainers(), this.buildConfigReferenceForInitContainers());
    }

    private ConfigReference buildConfigReferenceForContainers() {
        return this.buildConfigReferenceForEnvVarValue("containers");
    }

    private ConfigReference buildConfigReferenceForInitContainers() {
        return this.buildConfigReferenceForEnvVarValue("initContainers");
    }

    private ConfigReference buildConfigReferenceForEnvVarValue(String from) {
        String property = ConfigReference.joinProperties((String[])new String[]{"envs." + this.name});
        String path = "(metadata.name == " + this.getDeploymentName() + ").spec.template.spec." + from + ".(name == " + this.getContainerName() + ").env.(name == " + this.name + ").value";
        return new ConfigReference.Builder(property, path).withValue((Object)this.value).build();
    }
}

