/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment.utils;

import io.dekorate.utils.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class SystemPropertiesUtils {
    private static final String SYSTEM_PROPERTY_START = "${";
    private static final String SYSTEM_PROPERTY_END = "}";

    private SystemPropertiesUtils() {
    }

    public static boolean hasSystemProperties(String rawValue) {
        return StringUtils.isNotEmpty((CharSequence)rawValue) && rawValue.contains(SYSTEM_PROPERTY_START);
    }

    public static List<String> getSystemProperties(String str) {
        return SystemPropertiesUtils.substringsBetween(str, SYSTEM_PROPERTY_START, SYSTEM_PROPERTY_END);
    }

    public static String getPropertyFromSystem(String propertyName, String defaultValue) {
        String value = Optional.ofNullable(System.getProperty(propertyName)).orElseGet(() -> System.getenv(propertyName));
        return Strings.defaultIfEmpty((String)value, (String)defaultValue);
    }

    private static List<String> substringsBetween(String str, String open, String close) {
        int end;
        int start;
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)open) || StringUtils.isEmpty((CharSequence)close)) {
            return Collections.emptyList();
        }
        int closeLen = close.length();
        int openLen = open.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < str.length() - closeLen && (start = str.indexOf(open, pos)) >= 0 && (end = str.indexOf(close, start += openLen)) >= 0) {
            String currentStr = str.substring(start);
            String tentative = currentStr.substring(0, end - start);
            while (SystemPropertiesUtils.countMatches(tentative, open) != SystemPropertiesUtils.countMatches(tentative, close) && ++end < str.length()) {
                tentative = currentStr.substring(0, end - start);
            }
            list.add(tentative);
            pos = end + closeLen;
        }
        return list;
    }

    private static int countMatches(String str, String sub) {
        if (!io.github.yamlpath.utils.StringUtils.isNullOrEmpty((String)str) && !io.github.yamlpath.utils.StringUtils.isNullOrEmpty((String)sub)) {
            int count = 0;
            int idx = 0;
            while ((idx = str.indexOf(sub, idx)) != -1) {
                ++count;
                idx += sub.length();
            }
            return count;
        }
        return 0;
    }
}

