/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment;

import io.dekorate.ConfigReference;
import io.dekorate.Session;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.project.Project;
import io.quarkiverse.helm.deployment.AddIfStatementConfig;
import io.quarkiverse.helm.deployment.DisableDefaultHelmListener;
import io.quarkiverse.helm.deployment.HelmChartConfig;
import io.quarkiverse.helm.deployment.HelmChartUploader;
import io.quarkiverse.helm.deployment.HelmDependencyConfig;
import io.quarkiverse.helm.deployment.HelmEnabled;
import io.quarkiverse.helm.deployment.QuarkusHelmWriterSessionListener;
import io.quarkiverse.helm.deployment.ValueReferenceConfig;
import io.quarkiverse.helm.deployment.decorators.LowPriorityAddEnvVarDecorator;
import io.quarkiverse.helm.deployment.rules.ConfigReferenceStrategyManager;
import io.quarkiverse.helm.deployment.utils.HelmConfigUtils;
import io.quarkiverse.helm.deployment.utils.SystemPropertiesUtils;
import io.quarkiverse.helm.spi.CustomHelmOutputDirBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.DekorateOutputBuildItem;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.jboss.logging.Logger;

public class HelmProcessor {
    private static final Logger LOGGER = Logger.getLogger(HelmProcessor.class);
    private static final String NAME_FORMAT_REG_EXP = "[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*";
    private static final List<String> HELM_INVALID_CHARACTERS = Arrays.asList("-");
    private static final String BUILD_TIME_PROPERTIES = "/build-time-list";
    private static final String INIT_CONTAINER_CONDITION_FORMAT = "$(env | grep %s | grep -q false) && exit 0; %s";
    private static final String QUARKUS_KUBERNETES_NAME = "quarkus.kubernetes.name";
    private static final String QUARKUS_KNATIVE_NAME = "quarkus.knative.name";
    private static final String QUARKUS_OPENSHIFT_NAME = "quarkus.openshift.name";
    private static final String QUARKUS_CONTAINER_IMAGE_NAME = "quarkus.container-image.name";
    private static final String SERVICE_NAME_PLACEHOLDER = "::service-name";
    private static final String SERVICE_PORT_PLACEHOLDER = "::service-port";
    private static final String SPLIT = ":";
    private static final String PROPERTIES_CONFIG_SOURCE = "PropertiesConfigSource";
    private static final String YAML_CONFIG_SOURCE = "YamlConfigSource";
    private static Set<String> buildProperties;

    @BuildStep(onlyIf={HelmEnabled.class, IsNormal.class})
    void mapSystemPropertiesIfEnabled(Capabilities capabilities, ApplicationInfoBuildItem info, HelmChartConfig helmConfig, BuildProducer<DecoratorBuildItem> decorators) {
        if (helmConfig.mapSystemProperties()) {
            String deploymentName = HelmProcessor.getDeploymentName(capabilities, info);
            Config config = ConfigProvider.getConfig();
            HashMap<String, String> propertiesFromConfigSource = new HashMap<String, String>();
            for (String string : config.getPropertyNames()) {
                ConfigValue propValue = config.getConfigValue(string);
                if (!this.isPropertiesConfigSource(propValue.getSourceName())) continue;
                propertiesFromConfigSource.put(string, propValue.getRawValue());
            }
            for (Map.Entry entry : propertiesFromConfigSource.entrySet()) {
                if (this.isBuildTimeProperty((String)entry.getKey())) continue;
                this.mapProperty(deploymentName, decorators, (String)entry.getValue(), propertiesFromConfigSource);
            }
        }
    }

    @BuildStep(onlyIf={HelmEnabled.class, IsNormal.class})
    void configureHelmDependencyOrder(Capabilities capabilities, ApplicationInfoBuildItem info, HelmChartConfig config, BuildProducer<DecoratorBuildItem> decorators) {
        if (config.dependencies() == null || config.dependencies().isEmpty()) {
            return;
        }
        String deploymentName = HelmProcessor.getDeploymentName(capabilities, info);
        for (Map.Entry<String, HelmDependencyConfig> entry : config.dependencies().entrySet()) {
            HelmDependencyConfig dependency = entry.getValue();
            if (!dependency.waitForService().isPresent()) continue;
            String containerName = "wait-for-" + this.defaultString(dependency.name(), entry.getKey());
            ContainerBuilder container = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(containerName)).withImage(dependency.waitForServiceImage())).withCommand(new String[]{"sh"});
            String argument = null;
            String service = dependency.waitForService().get();
            if (service.contains(SPLIT)) {
                String[] parts = service.split(SPLIT);
                String serviceName = parts[0];
                String servicePort = parts[1];
                argument = dependency.waitForServicePortCommandTemplate().replaceAll(SERVICE_NAME_PLACEHOLDER, serviceName).replaceAll(SERVICE_PORT_PLACEHOLDER, servicePort);
            } else {
                argument = dependency.waitForServiceOnlyCommandTemplate().replaceAll(SERVICE_NAME_PLACEHOLDER, service);
            }
            if (dependency.condition().isPresent()) {
                String property = HelmConfigUtils.deductProperty(config, dependency.condition().get());
                decorators.produce((BuildItem)new DecoratorBuildItem((Object)new LowPriorityAddEnvVarDecorator(deploymentName, containerName, property, "true")));
                argument = String.format(INIT_CONTAINER_CONDITION_FORMAT, property, argument);
            }
            decorators.produce((BuildItem)new DecoratorBuildItem((Object)new AddInitContainerDecorator(deploymentName, (Container)((ContainerBuilder)container.withArguments(new String[]{"-c", argument})).build())));
        }
    }

    @BuildStep(onlyIf={HelmEnabled.class, IsNormal.class})
    void generateResources(ApplicationInfoBuildItem app, OutputTargetBuildItem outputTarget, Optional<DekorateOutputBuildItem> dekorateOutput, List<GeneratedKubernetesResourceBuildItem> generatedResources, BuildProducer<ArtifactResultBuildItem> dummy, Optional<CustomHelmOutputDirBuildItem> customHelmOutputDir, HelmChartConfig config) {
        if (dekorateOutput.isPresent()) {
            this.doGenerateResources(app, outputTarget, dekorateOutput.get(), generatedResources, customHelmOutputDir, config);
        } else if (config.enabled()) {
            LOGGER.warn((Object)"Quarkus Helm extension is skipped since no Quarkus Kubernetes extension is configured. ");
        }
    }

    @BuildStep
    void disableDefaultHelmListener(BuildProducer<ConfiguratorBuildItem> helmConfiguration) {
        helmConfiguration.produce((BuildItem)new ConfiguratorBuildItem((Object)new DisableDefaultHelmListener()));
    }

    private void doGenerateResources(ApplicationInfoBuildItem app, OutputTargetBuildItem outputTarget, DekorateOutputBuildItem dekorateOutput, List<GeneratedKubernetesResourceBuildItem> generatedResources, Optional<CustomHelmOutputDirBuildItem> customHelmOutputDir, HelmChartConfig config) {
        this.validate(config);
        Project project = (Project)dekorateOutput.getProject();
        Path inputFolder = this.getInputDirectory(config, project);
        Path outputFolder = this.getOutputDirectory(config, customHelmOutputDir, outputTarget);
        QuarkusHelmWriterSessionListener helmWriter = new QuarkusHelmWriterSessionListener();
        Map<String, Set<File>> deploymentTargets = this.toDeploymentTargets(dekorateOutput.getGeneratedFiles(), generatedResources);
        String deploymentTargetToPush = this.deductDeploymentTarget(config, deploymentTargets);
        for (Map.Entry<String, Set<File>> filesInDeploymentTarget : deploymentTargets.entrySet()) {
            String deploymentTarget = filesInDeploymentTarget.getKey();
            Path chartOutputFolder = outputFolder.resolve(deploymentTarget);
            this.deleteOutputHelmFolderIfExists(chartOutputFolder);
            Map<String, String> generated = helmWriter.writeHelmFiles(config.name().orElse(app.getName()), project, config, this.getConfigReferencesFromSession(deploymentTarget, dekorateOutput), inputFolder, chartOutputFolder, (Collection<File>)filesInDeploymentTarget.getValue());
            if (!config.repository().push() || !deploymentTargetToPush.equals(deploymentTarget)) continue;
            String tarball = generated.keySet().stream().filter(file -> file.endsWith(config.extension())).findFirst().orElseThrow(() -> new RuntimeException("Couldn't find the tarball file. There should have been generated when pushing to a Helm repository is enabled."));
            HelmChartUploader.pushToHelmRepository(new File(tarball), config.repository());
        }
    }

    private void validate(HelmChartConfig config) {
        String name;
        if (config.name().isPresent() && !config.name().get().matches(NAME_FORMAT_REG_EXP)) {
            throw new IllegalStateException(String.format("Wrong name '%s'. Regular expression used for validation is '%s'", config.name().get(), NAME_FORMAT_REG_EXP));
        }
        for (Map.Entry<String, AddIfStatementConfig> entry : config.addIfStatement().entrySet()) {
            name = entry.getValue().property().orElse(entry.getKey());
            if (entry.getValue().onResourceKind().isEmpty() && entry.getValue().onResourceName().isEmpty()) {
                throw new IllegalStateException(String.format("Either 'quarkus.helm.add-if-statement.%s.on-resource-kind' or 'quarkus.helm.add-if-statement.%s.on-resource-kind' must be provided.", entry.getKey(), entry.getKey()));
            }
            if (config.disableNamingValidation()) continue;
            if (!HELM_INVALID_CHARACTERS.stream().anyMatch(name::contains)) continue;
            throw new RuntimeException(String.format("The property of the `add-if-statement` '%s' is invalid. Can't use '-' characters.You can disable the naming validation using `quarkus.helm.disable-naming-validation=true`", name));
        }
        if (!config.disableNamingValidation()) {
            for (Map.Entry<String, Object> entry : config.dependencies().entrySet()) {
                name = ((HelmDependencyConfig)entry.getValue()).name().orElse(entry.getKey());
                if (!((HelmDependencyConfig)entry.getValue()).condition().isPresent()) continue;
                if (!HELM_INVALID_CHARACTERS.stream().anyMatch(((HelmDependencyConfig)entry.getValue()).condition().get()::contains)) continue;
                throw new RuntimeException(String.format("Condition of the dependency '%s' is invalid. Can't use '-' characters.You can disable the naming validation using `quarkus.helm.disable-naming-validation=true`", name));
            }
            for (Map.Entry<String, Object> entry : config.values().entrySet()) {
                name = ((ValueReferenceConfig)entry.getValue()).property().orElse(entry.getKey());
                if (!HELM_INVALID_CHARACTERS.stream().anyMatch(name::contains)) continue;
                throw new RuntimeException(String.format("Property of the value '%s' is invalid. Can't use '-' characters.You can disable the naming validation using `quarkus.helm.disable-naming-validation=true`", name));
            }
        }
    }

    private String deductDeploymentTarget(HelmChartConfig config, Map<String, Set<File>> deploymentTargets) {
        if (config.repository().push()) {
            if (config.repository().deploymentTarget().isPresent()) {
                return config.repository().deploymentTarget().get();
            }
            List deploymentTargetNames = deploymentTargets.keySet().stream().collect(Collectors.toList());
            if (deploymentTargetNames.size() == 1) {
                return (String)deploymentTargetNames.get(0);
            }
            throw new IllegalStateException("Multiple deployment target found: '" + deploymentTargetNames.stream().collect(Collectors.joining(", ")) + "'. To push the Helm Chart to the repository, you need to select only one using the property `quarkus.helm.repository.deployment-target`");
        }
        return null;
    }

    private void deleteOutputHelmFolderIfExists(Path outputFolder) {
        try {
            FileUtil.deleteIfExists((Path)outputFolder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Path getInputDirectory(HelmChartConfig config, Project project) {
        Path path = Paths.get(config.inputDirectory(), new String[0]);
        if (!path.isAbsolute()) {
            return project.getRoot().resolve(path);
        }
        return path;
    }

    private Path getOutputDirectory(HelmChartConfig config, Optional<CustomHelmOutputDirBuildItem> customHelmOutputDir, OutputTargetBuildItem outputTarget) {
        return customHelmOutputDir.map(CustomHelmOutputDirBuildItem::getOutputDir).orElse(outputTarget.getOutputDirectory().resolve(config.outputDirectory()));
    }

    private Map<String, Set<File>> toDeploymentTargets(List<String> generatedFiles, List<GeneratedKubernetesResourceBuildItem> generatedResources) {
        HashMap<String, Set<File>> filesByDeploymentTarget = new HashMap<String, Set<File>>();
        for (String generatedFile : generatedFiles) {
            File file;
            String deploymentTarget;
            if (generatedFile.toLowerCase(Locale.ROOT).endsWith(".json") || filesByDeploymentTarget.containsKey(deploymentTarget = (file = new File(generatedFile)).getName().substring(0, file.getName().indexOf(".")))) continue;
            HashSet<File> files = new HashSet<File>();
            if (!file.exists()) {
                Optional<byte[]> content = generatedResources.stream().filter(resource -> file.getName().equals(resource.getName())).map(GeneratedKubernetesResourceBuildItem::getContent).findFirst();
                if (content.isPresent()) {
                    try {
                        File tempFile = File.createTempFile("tmp", file.getName());
                        tempFile.deleteOnExit();
                        Files.write(tempFile.toPath(), content.get(), new OpenOption[0]);
                        files.add(tempFile);
                    }
                    catch (IOException ignored) {
                        files.add(file);
                    }
                }
            } else {
                files.add(file);
            }
            filesByDeploymentTarget.put(deploymentTarget, files);
        }
        return filesByDeploymentTarget;
    }

    private String defaultString(Optional<String> value, String defaultStr) {
        if (value.isEmpty() || StringUtils.isEmpty((CharSequence)value.get())) {
            return defaultStr;
        }
        return value.get();
    }

    private String mapProperty(String deploymentName, BuildProducer<DecoratorBuildItem> decorators, String property, Map<String, String> propertiesFromConfigSource) {
        if (!SystemPropertiesUtils.hasSystemProperties(property)) {
            return property;
        }
        String lastPropertyValue = property;
        for (String systemProperty : SystemPropertiesUtils.getSystemProperties(property)) {
            String defaultValue = "";
            if (systemProperty.contains(SPLIT)) {
                int splitPosition = systemProperty.indexOf(SPLIT);
                defaultValue = systemProperty.substring(splitPosition + SPLIT.length());
                systemProperty = systemProperty.substring(0, splitPosition);
                if (SystemPropertiesUtils.hasSystemProperties(defaultValue)) {
                    defaultValue = this.mapProperty(deploymentName, decorators, defaultValue, propertiesFromConfigSource);
                }
            }
            if (propertiesFromConfigSource.containsKey(systemProperty)) continue;
            if (!HELM_INVALID_CHARACTERS.stream().noneMatch(systemProperty::contains) || this.isBuildTimeProperty(systemProperty)) continue;
            defaultValue = SystemPropertiesUtils.getPropertyFromSystem(systemProperty, defaultValue);
            decorators.produce((BuildItem)new DecoratorBuildItem((Object)new LowPriorityAddEnvVarDecorator(deploymentName, systemProperty, defaultValue)));
            lastPropertyValue = defaultValue;
        }
        return lastPropertyValue;
    }

    public static String getDeploymentName(Capabilities capabilities, ApplicationInfoBuildItem info) {
        Config config = ConfigProvider.getConfig();
        Optional resourceName = capabilities.isPresent("io.quarkus.openshift") ? config.getOptionalValue(QUARKUS_OPENSHIFT_NAME, String.class) : config.getOptionalValue(QUARKUS_KNATIVE_NAME, String.class).or(() -> config.getOptionalValue(QUARKUS_KUBERNETES_NAME, String.class));
        return resourceName.or(() -> config.getOptionalValue(QUARKUS_CONTAINER_IMAGE_NAME, String.class)).orElse(info.getName());
    }

    private boolean isPropertiesConfigSource(String sourceName) {
        return StringUtils.isNotEmpty((CharSequence)sourceName) && (sourceName.startsWith(PROPERTIES_CONFIG_SOURCE) || sourceName.startsWith(YAML_CONFIG_SOURCE));
    }

    private boolean isBuildTimeProperty(String name) {
        if (buildProperties == null) {
            buildProperties = new HashSet<String>();
            try {
                Scanner scanner = new Scanner(HelmProcessor.class.getResourceAsStream(BUILD_TIME_PROPERTIES));
                while (scanner.hasNextLine()) {
                    buildProperties.add(scanner.nextLine());
                }
            }
            catch (Exception e) {
                LOGGER.debugf("Can't read the build time properties file at '%s'. Caused by: %s", (Object)BUILD_TIME_PROPERTIES, (Object)e.getMessage());
            }
        }
        return buildProperties.stream().anyMatch(build -> name.matches((String)build) || build.endsWith(".") && name.startsWith((String)build) || name.equals(build));
    }

    private List<ConfigReference> getConfigReferencesFromSession(String deploymentTarget, DekorateOutputBuildItem dekorateOutput) {
        List<ConfigReference> configReferencesFromDecorators = ((Session)dekorateOutput.getSession()).getResourceRegistry().getConfigReferences(deploymentTarget).stream().flatMap(decorator -> decorator.getConfigReferences().stream()).map(ConfigReferenceStrategyManager::visit).collect(Collectors.toList());
        Collections.reverse(configReferencesFromDecorators);
        return configReferencesFromDecorators;
    }
}

