/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment.utils;

import io.dekorate.ConfigReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ValuesHolder {
    private final Map<String, HelmValueHolder> prodValues = new HashMap<String, HelmValueHolder>();
    private final Map<String, Map<String, HelmValueHolder>> valuesByProfile = new HashMap<String, Map<String, HelmValueHolder>>();

    public Map<String, HelmValueHolder> getProdValues() {
        return Collections.unmodifiableMap(this.prodValues);
    }

    public Map<String, Map<String, HelmValueHolder>> getValuesByProfile() {
        return Collections.unmodifiableMap(this.valuesByProfile);
    }

    public void put(String property, ConfigReference config) {
        this.put(property, config, config.getValue(), config.getProfile());
    }

    public void put(String property, ConfigReference config, Object value) {
        this.prodValues.put(property, new HelmValueHolder(value, config));
    }

    public void put(String property, ConfigReference config, Object value, String profile) {
        this.get(profile).put(property, new HelmValueHolder(value, config));
    }

    public void putIfAbsent(String property, ConfigReference config, Object value, String profile) {
        this.get(profile).putIfAbsent(property, new HelmValueHolder(value, config));
    }

    public Map<String, HelmValueHolder> get(String profile) {
        Map values = this.prodValues;
        if (StringUtils.isNotEmpty((CharSequence)profile)) {
            values = this.valuesByProfile.computeIfAbsent(profile, p -> new HashMap());
        }
        return values;
    }

    public static class HelmValueHolder {
        public final Object value;
        public final ConfigReference configReference;

        public HelmValueHolder(Object value, ConfigReference configReference) {
            this.value = value;
            this.configReference = configReference;
        }
    }
}

