/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import io.dekorate.ConfigReference;
import io.dekorate.utils.Serialization;
import io.quarkiverse.helm.deployment.HelmChartConfig;
import io.quarkiverse.helm.deployment.ValuesSchemaPropertyConfig;
import io.quarkiverse.helm.deployment.model.ValuesSchema;
import io.quarkiverse.helm.deployment.model.ValuesSchemaProperty;
import io.quarkiverse.helm.deployment.utils.HelmConfigUtils;
import io.quarkiverse.helm.deployment.utils.ValuesHolder;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class ValuesSchemaUtils {
    private ValuesSchemaUtils() {
    }

    public static Map<String, Object> createSchema(HelmChartConfig helmConfig, Map<String, ValuesHolder.HelmValueHolder> prodValues) {
        String propertyName;
        ValuesSchemaProperty next;
        String part;
        Map<String, ValuesSchemaProperty> location;
        ValuesSchemaProperty parent;
        String[] tree;
        ValuesSchema schema = new ValuesSchema();
        schema.setTitle(helmConfig.valuesSchema().title());
        for (Map.Entry<String, ValuesHolder.HelmValueHolder> entry : prodValues.entrySet()) {
            ConfigReference configReference = entry.getValue().configReference;
            tree = HelmConfigUtils.deductProperty(helmConfig, entry.getKey()).split(Pattern.quote("."));
            parent = null;
            location = schema.getProperties();
            for (int index = 0; index < tree.length - 1; ++index) {
                part = tree[index];
                next = location.get(part);
                if (next == null) {
                    next = new ValuesSchemaProperty();
                    next.setType("object");
                    location.put(part, next);
                }
                parent = next;
                location = next.getProperties();
            }
            propertyName = tree[tree.length - 1];
            Object propertyValue = entry.getValue().value;
            ValuesSchemaProperty property = location.getOrDefault(propertyName, new ValuesSchemaProperty());
            property.setDescription(configReference.getDescription());
            property.setPattern(configReference.getPattern());
            property.setEnumValues(configReference.getEnumValues());
            property.setMaximum(configReference.getMaximum());
            property.setMinimum(configReference.getMinimum());
            if (configReference.isRequired()) {
                if (parent == null) {
                    schema.getRequired().add(propertyName);
                } else {
                    parent.getRequired().add(propertyName);
                }
            }
            if (propertyValue == null) {
                property.setType("null");
            } else if (propertyValue instanceof Integer) {
                property.setType("integer");
            } else if (propertyValue instanceof Number) {
                property.setType("number");
            } else if (propertyValue instanceof Collection) {
                property.setType("array");
            } else if (propertyValue instanceof Boolean) {
                property.setType("boolean");
            } else {
                property.setType("string");
            }
            location.put(propertyName, property);
        }
        for (Map.Entry<String, Object> entry : helmConfig.valuesSchema().properties().entrySet()) {
            String name = ((ValuesSchemaPropertyConfig)entry.getValue()).name().orElse(entry.getKey());
            tree = HelmConfigUtils.deductProperty(helmConfig, name).split(Pattern.quote("."));
            parent = null;
            location = schema.getProperties();
            for (int index = 0; index < tree.length - 1; ++index) {
                part = tree[index];
                next = location.get(part);
                if (next == null) {
                    next = new ValuesSchemaProperty();
                    next.setType("object");
                    location.put(part, next);
                }
                parent = next;
                location = next.getProperties();
            }
            propertyName = tree[tree.length - 1];
            ValuesSchemaProperty property = location.getOrDefault(propertyName, new ValuesSchemaProperty());
            ((ValuesSchemaPropertyConfig)entry.getValue()).description().ifPresent(property::setDescription);
            ((ValuesSchemaPropertyConfig)entry.getValue()).pattern().ifPresent(property::setPattern);
            ((ValuesSchemaPropertyConfig)entry.getValue()).maximum().ifPresent(property::setMaximum);
            ((ValuesSchemaPropertyConfig)entry.getValue()).minimum().ifPresent(property::setMinimum);
            if (((ValuesSchemaPropertyConfig)entry.getValue()).required()) {
                if (parent == null) {
                    schema.getRequired().add(propertyName);
                } else {
                    parent.getRequired().add(propertyName);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)((ValuesSchemaPropertyConfig)entry.getValue()).type())) {
                property.setType(((ValuesSchemaPropertyConfig)entry.getValue()).type());
            }
            location.put(propertyName, property);
        }
        return (Map)Serialization.unmarshal((String)Serialization.asJson((Object)schema), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

