/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.deployment;

import com.fasterxml.jackson.core.type.TypeReference;
import io.dekorate.ConfigReference;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.project.Project;
import io.dekorate.utils.Exec;
import io.dekorate.utils.Maps;
import io.dekorate.utils.Serialization;
import io.github.yamlpath.YamlExpressionParser;
import io.github.yamlpath.YamlPath;
import io.quarkiverse.helm.deployment.AddIfStatementConfig;
import io.quarkiverse.helm.deployment.ExpressionConfig;
import io.quarkiverse.helm.deployment.HelmChartConfig;
import io.quarkiverse.helm.deployment.HelmDependencyConfig;
import io.quarkiverse.helm.deployment.MaintainerConfig;
import io.quarkiverse.helm.deployment.ValueReferenceConfig;
import io.quarkiverse.helm.deployment.utils.FileUtils;
import io.quarkiverse.helm.deployment.utils.HelmConfigUtils;
import io.quarkiverse.helm.deployment.utils.HelmTarArchiver;
import io.quarkiverse.helm.deployment.utils.MapUtils;
import io.quarkiverse.helm.deployment.utils.ReadmeBuilder;
import io.quarkiverse.helm.deployment.utils.ValuesHolder;
import io.quarkiverse.helm.deployment.utils.ValuesSchemaUtils;
import io.quarkiverse.helm.deployment.utils.YamlExpressionParserUtils;
import io.quarkiverse.helm.model.Chart;
import io.quarkiverse.helm.model.HelmDependency;
import io.quarkiverse.helm.model.Maintainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class QuarkusHelmWriterSessionListener {
    private static final String YAML = ".yaml";
    private static final String YAML_REG_EXP = ".*?\\.ya?ml$";
    private static final String CHART_FILENAME = "Chart.yaml";
    private static final String VALUES = "values";
    private static final String TEMPLATES = "templates";
    private static final String CHARTS = "charts";
    private static final String NOTES = "NOTES.txt";
    private static final String VALUES_SCHEMA = "values.schema.json";
    private static final String README = "README.md";
    private static final List<String> ADDITIONAL_CHART_FILES = Arrays.asList("LICENSE", "app-readme.md", "questions.yml", "questions.yaml", "requirements.yml", "requirements.yaml", "crds");
    private static final String KIND = "kind";
    private static final String METADATA = "metadata";
    private static final String NAME = "name";
    private static final String ENVIRONMENT_PROPERTY_GROUP = "envs.";
    private static final String IF_STATEMENT_START_TAG = "{{- if .Values.%s }}";
    private static final String TEMPLATE_FUNCTION_START_TAG = "{{- define";
    private static final String TEMPLATE_FUNCTION_END_TAG = "{{- end }}";
    private static final String HELM_HELPER_PREFIX = "_";
    private static final boolean APPEND = true;
    private static final Logger LOGGER = LoggerFactory.getLogger();

    public Map<String, String> writeHelmFiles(String name, Project project, HelmChartConfig helmConfig, List<ConfigReference> valueReferencesFromDecorators, Path inputDir, Path outputDir, Map<String, byte[]> generatedFiles) {
        HashMap<String, String> artifacts = new HashMap<String, String>();
        if (helmConfig.enabled()) {
            try {
                LOGGER.info(String.format("Creating Helm Chart \"%s\"", name));
                ValuesHolder values = this.populateValuesFromConfig(helmConfig, inputDir);
                List<Map<Object, Object>> resources = this.populateValuesFromConfigReferences(helmConfig, generatedFiles, values, valueReferencesFromDecorators);
                artifacts.putAll(this.processTemplates(name, helmConfig, inputDir, outputDir, resources));
                artifacts.putAll(this.createChartYaml(name, helmConfig, project, inputDir, outputDir));
                artifacts.putAll(this.createValuesYaml(name, helmConfig, inputDir, outputDir, values));
                artifacts.putAll(this.createEmptyChartFolder(name, outputDir));
                artifacts.putAll(this.addNotesIntoTemplatesFolder(name, helmConfig, inputDir, outputDir));
                artifacts.putAll(this.addAdditionalResources(name, inputDir, outputDir));
                if (helmConfig.createTarFile() || helmConfig.repository().push()) {
                    this.fetchDependencies(name, helmConfig, outputDir);
                    artifacts.putAll(this.createTarball(name, helmConfig, project, outputDir, artifacts));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing resources", e);
            }
        }
        return artifacts;
    }

    private Map<String, String> addAdditionalResources(String name, Path inputDir, Path outputDir) throws IOException {
        if (inputDir == null || !inputDir.toFile().exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> artifacts = new HashMap<String, String>();
        for (File source : inputDir.toFile().listFiles()) {
            if (!ADDITIONAL_CHART_FILES.stream().anyMatch(source.getName()::equalsIgnoreCase)) continue;
            artifacts.putAll(this.addAdditionalResource(name, outputDir, source));
        }
        return artifacts;
    }

    private Map<String, String> addAdditionalResource(String name, Path outputDir, File source) throws IOException {
        if (!source.exists()) {
            return Collections.emptyMap();
        }
        Path destination = this.getChartOutputDir(name, outputDir).resolve(source.getName());
        if (source.isDirectory()) {
            Files.createDirectory(destination, new FileAttribute[0]);
            for (File file : source.listFiles()) {
                Files.copy(new FileInputStream(file), destination.resolve(file.getName()), new CopyOption[0]);
            }
        } else {
            Files.copy(new FileInputStream(source), destination, new CopyOption[0]);
        }
        return Collections.singletonMap(destination.toString(), "");
    }

    private void fetchDependencies(String name, HelmChartConfig helmConfig, Path outputDir) {
        if (helmConfig.dependencies() != null && !helmConfig.dependencies().isEmpty()) {
            Path chartFolder = this.getChartOutputDir(name, outputDir);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            boolean success = Exec.inPath((Path)chartFolder).redirectingOutput((OutputStream)out).commands(new String[]{"helm", "dependency", "build"});
            if (success) {
                LOGGER.info("Dependencies successfully fetched");
            } else {
                throw new RuntimeException("Error fetching Helm dependencies. Cause: " + new String(out.toByteArray()));
            }
        }
    }

    private Map<String, String> addNotesIntoTemplatesFolder(String name, HelmChartConfig helmConfig, Path inputDir, Path outputDir) throws IOException {
        InputStream notesInputStream;
        File notesInInputDir = inputDir.resolve(NOTES).toFile();
        if (notesInInputDir.exists()) {
            notesInputStream = new FileInputStream(notesInInputDir);
        } else {
            if (ObjectUtils.isEmpty((Object)helmConfig.notes())) {
                return Collections.emptyMap();
            }
            notesInputStream = this.getResourceFromClasspath(helmConfig.notes());
        }
        if (notesInputStream == null) {
            throw new RuntimeException("Could not find the notes template file in the classpath at " + helmConfig.notes());
        }
        Path chartOutputDir = this.getChartOutputDir(name, outputDir).resolve(TEMPLATES).resolve(NOTES);
        Files.copy(notesInputStream, chartOutputDir, new CopyOption[0]);
        return Collections.singletonMap(chartOutputDir.toString(), "");
    }

    private InputStream getResourceFromClasspath(String notes) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(notes);
    }

    private Map<String, String> createEmptyChartFolder(String name, Path outputDir) throws IOException {
        Path emptyChartsDir = this.getChartOutputDir(name, outputDir).resolve(CHARTS);
        Files.createDirectories(emptyChartsDir, new FileAttribute[0]);
        return Collections.singletonMap(emptyChartsDir.toString(), "");
    }

    private Map<String, String> createValuesYaml(String name, HelmChartConfig helmConfig, Path inputDir, Path outputDir, ValuesHolder valuesHolder) throws IOException {
        Map<String, ValuesHolder.HelmValueHolder> prodValues = valuesHolder.getProdValues();
        Map<String, Map<String, ValuesHolder.HelmValueHolder>> valuesByProfile = valuesHolder.getValuesByProfile();
        HashMap<String, String> artifacts = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, ValuesHolder.HelmValueHolder>> valuesInProfile : valuesByProfile.entrySet()) {
            String profile = valuesInProfile.getKey();
            Map<String, ValuesHolder.HelmValueHolder> values = valuesInProfile.getValue();
            for (Map.Entry<String, ValuesHolder.HelmValueHolder> prodValue : prodValues.entrySet()) {
                if (values.containsKey(prodValue.getKey())) continue;
                values.put(prodValue.getKey(), prodValue.getValue());
            }
            artifacts.putAll(this.writeFileAsYaml(this.mergeWithFileIfExists(inputDir, VALUES + helmConfig.valuesProfileSeparator() + profile + YAML, this.toValuesMap(values)), this.getChartOutputDir(name, outputDir).resolve(VALUES + helmConfig.valuesProfileSeparator() + profile + YAML)));
        }
        artifacts.putAll(this.writeFileAsYaml(this.toValuesMap(prodValues), this.getChartOutputDir(name, outputDir).resolve("values.yaml")));
        if (helmConfig.createValuesSchemaFile()) {
            Map<String, Object> schemaAsMap = ValuesSchemaUtils.createSchema(helmConfig, prodValues);
            artifacts.putAll(this.writeFileAsJson(this.mergeWithFileIfExists(inputDir, VALUES_SCHEMA, MapUtils.toMultiValueSortedMap(schemaAsMap)), this.getChartOutputDir(name, outputDir).resolve(VALUES_SCHEMA)));
        } else {
            artifacts.putAll(this.addAdditionalResource(name, outputDir, inputDir.resolve(VALUES_SCHEMA).toFile()));
        }
        if (helmConfig.createReadmeFile()) {
            String readmeContent = ReadmeBuilder.build(name, helmConfig, prodValues);
            artifacts.putAll(this.writeFile(readmeContent, this.getChartOutputDir(name, outputDir).resolve(README)));
        } else {
            artifacts.putAll(this.addAdditionalResource(name, outputDir, inputDir.resolve(README).toFile()));
        }
        return artifacts;
    }

    private Map<String, Object> toValuesMap(Map<String, ValuesHolder.HelmValueHolder> holder) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, ValuesHolder.HelmValueHolder> value : holder.entrySet()) {
            values.put(value.getKey(), value.getValue().value);
        }
        return MapUtils.toMultiValueSortedMap(values);
    }

    private Map<String, Object> mergeWithFileIfExists(Path inputDir, String file, Map<String, Object> valuesAsMultiValueMap) {
        File templateValuesFile = inputDir.resolve(file).toFile();
        if (templateValuesFile.exists()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Map yaml = (Map)Serialization.unmarshal((File)templateValuesFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
            result.putAll(yaml);
            Maps.merge(valuesAsMultiValueMap, result);
            Maps.merge(result, valuesAsMultiValueMap);
            return result;
        }
        return valuesAsMultiValueMap;
    }

    private Map<String, String> createTarball(String name, HelmChartConfig helmConfig, Project project, Path outputDir, Map<String, String> artifacts) throws IOException {
        File tarballFile = outputDir.resolve(String.format("%s-%s%s.%s", name, this.getVersion(helmConfig, project), helmConfig.tarFileClassifier().map(c -> "-" + c).orElse(""), helmConfig.extension())).toFile();
        LOGGER.debug(String.format("Creating Helm configuration Tarball: '%s'", tarballFile));
        Path helmSources = this.getChartOutputDir(name, outputDir);
        ArrayList<File> files = new ArrayList<File>();
        for (String filePath : artifacts.keySet()) {
            File file = new File(filePath);
            if (file.isDirectory()) {
                files.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            files.add(file);
        }
        HelmTarArchiver.createTarBall(tarballFile, helmSources.toFile(), files, helmConfig.extension(), tae -> tae.setName(String.format("%s/%s", name, tae.getName())));
        return Collections.singletonMap(tarballFile.toString(), null);
    }

    private String getVersion(HelmChartConfig helmConfig, Project project) {
        return helmConfig.version().orElse(project.getBuildInfo().getVersion());
    }

    private Map<String, String> processTemplates(String name, HelmChartConfig helmConfig, Path inputDir, Path outputDir, List<Map<Object, Object>> resources) throws IOException {
        HashMap<String, String> templates = new HashMap<String, String>();
        Path templatesDir = this.getChartOutputDir(name, outputDir).resolve(TEMPLATES);
        Files.createDirectories(templatesDir, new FileAttribute[0]);
        Map<String, String> functionsByResource = this.processUserDefinedTemplates(inputDir, templates, templatesDir);
        for (Map<Object, Object> resource : resources) {
            if (helmConfig.expressions() != null) {
                YamlExpressionParser parser = new YamlExpressionParser(Arrays.asList(resource));
                for (ExpressionConfig expressionConfig : helmConfig.expressions().values()) {
                    if (expressionConfig.path() == null || expressionConfig.expression() == null) continue;
                    YamlExpressionParserUtils.readAndSet(parser, expressionConfig.path(), expressionConfig.expression());
                }
            }
            String kind = (String)resource.get(KIND);
            Path targetFile = templatesDir.resolve(kind.toLowerCase() + YAML);
            String functions = functionsByResource.get(kind.toLowerCase() + YAML);
            Object adaptedString = Serialization.yamlMapper().writeValueAsString(resource);
            if (functions != null) {
                adaptedString = functions + System.lineSeparator() + (String)adaptedString;
            }
            for (Map.Entry<String, AddIfStatementConfig> addIfStatement : helmConfig.addIfStatement().entrySet()) {
                AddIfStatementConfig addIfStatementConfig = addIfStatement.getValue();
                if (!addIfStatementConfig.onResourceKind().isEmpty() && !addIfStatementConfig.onResourceKind().get().equals(kind) || !addIfStatementConfig.onResourceName().isEmpty() && !addIfStatementConfig.onResourceName().get().equals(this.getNameFromResource(resource))) continue;
                String propertyName = addIfStatementConfig.property().orElse(addIfStatement.getKey());
                String property = HelmConfigUtils.deductProperty(helmConfig, propertyName);
                adaptedString = String.format(IF_STATEMENT_START_TAG, property) + System.lineSeparator() + (String)adaptedString + System.lineSeparator() + TEMPLATE_FUNCTION_END_TAG + System.lineSeparator();
            }
            adaptedString = QuarkusHelmWriterSessionListener.applyKnownPatterns((String)adaptedString);
            this.writeFile((String)adaptedString, targetFile);
            templates.put(targetFile.toString(), (String)adaptedString);
        }
        return templates;
    }

    private String getNameFromResource(Map<Object, Object> resource) {
        Object name;
        Object metadata = resource.get(METADATA);
        if (metadata != null && metadata instanceof Map && (name = ((Map)metadata).get(NAME)) != null) {
            return name.toString();
        }
        return null;
    }

    private Map<String, String> processUserDefinedTemplates(Path inputDir, Map<String, String> templates, Path templatesDir) throws IOException {
        HashMap<String, String> functionsByResource = new HashMap<String, String>();
        File inputTemplates = inputDir.resolve(TEMPLATES).toFile();
        if (inputTemplates.exists()) {
            File[] userTemplates;
            for (File userTemplateFile : userTemplates = inputTemplates.listFiles()) {
                if (userTemplateFile.getName().startsWith(HELM_HELPER_PREFIX)) {
                    Path output = templatesDir.resolve(userTemplateFile.getName());
                    Files.copy(new FileInputStream(userTemplateFile), output, new CopyOption[0]);
                    templates.put(output.toString(), "");
                    continue;
                }
                String[] userResource = FileUtils.lines(userTemplateFile);
                StringBuilder sb = new StringBuilder();
                boolean isFunction = false;
                for (String lineUserResource : userResource) {
                    if (!lineUserResource.contains(TEMPLATE_FUNCTION_START_TAG) && !isFunction) continue;
                    isFunction = !lineUserResource.contains(TEMPLATE_FUNCTION_END_TAG);
                    sb.append(lineUserResource + System.lineSeparator());
                }
                functionsByResource.put(userTemplateFile.getName(), sb.toString());
            }
        }
        return functionsByResource;
    }

    private ValuesHolder populateValuesFromConfig(HelmChartConfig helmConfig, Path inputDir) {
        ValuesHolder values = new ValuesHolder();
        for (Map.Entry<String, HelmDependencyConfig> entry : helmConfig.dependencies().entrySet()) {
            entry.getValue().condition().ifPresent(condition -> {
                String dependencyName = ((HelmDependencyConfig)dependency.getValue()).name().orElse((String)dependency.getKey());
                String propertyName = HelmConfigUtils.deductProperty(helmConfig, condition);
                ConfigReference configReference = new ConfigReference.Builder(propertyName, new String[0]).withDescription("Flag to enable/disable the dependency '" + dependencyName + "'").build();
                values.put(propertyName, configReference, true);
            });
        }
        for (Map.Entry<String, Object> entry : helmConfig.addIfStatement().entrySet()) {
            String property = ((AddIfStatementConfig)entry.getValue()).property().orElse(entry.getKey());
            String propertyName = HelmConfigUtils.deductProperty(helmConfig, property);
            ConfigReference configReference = new ConfigReference.Builder(propertyName, new String[0]).withDescription(((AddIfStatementConfig)entry.getValue()).description()).withValue((Object)((AddIfStatementConfig)entry.getValue()).withDefaultValue()).build();
            values.put(propertyName, configReference);
        }
        File templateValuesFile = inputDir.resolve("values.yaml").toFile();
        if (templateValuesFile.exists()) {
            Map<String, Object> map = MapUtils.toPlainMap((Map)Serialization.unmarshal((File)templateValuesFile, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String str;
                Object value = entry.getValue();
                Object object = entry.getValue();
                if (object instanceof String && (str = (String)object).contains(" ")) {
                    value = ":DOUBLE_QUOTES" + str + ":DOUBLE_QUOTES";
                }
                ConfigReference configReference = new ConfigReference.Builder(entry.getKey(), new String[0]).withValue(value).build();
                values.put(entry.getKey(), configReference);
            }
        }
        return values;
    }

    private List<Map<Object, Object>> populateValuesFromConfigReferences(HelmChartConfig helmConfig, Map<String, byte[]> generatedFiles, ValuesHolder values, List<ConfigReference> valuesReferencesFromDecorators) throws IOException {
        List valuesReferencesFromUser = helmConfig.values().entrySet().stream().map(e -> new ConfigReference.Builder(((ValueReferenceConfig)e.getValue()).property().orElse((String)e.getKey()), ((ValueReferenceConfig)e.getValue()).paths().map(l -> l.toArray(new String[0])).orElse(new String[0])).withValue(this.toValue((ValueReferenceConfig)e.getValue())).withDescription(((ValueReferenceConfig)e.getValue()).description().orElse("")).withExpression((String)((ValueReferenceConfig)e.getValue()).expression().orElse(null)).withProfile((String)((ValueReferenceConfig)e.getValue()).profile().orElse(null)).withRequired(((ValueReferenceConfig)e.getValue()).required()).withPattern((String)((ValueReferenceConfig)e.getValue()).pattern().orElse(null)).withMaximum(((ValueReferenceConfig)e.getValue()).maximum().orElse(Integer.MAX_VALUE).intValue()).withMinimum(((ValueReferenceConfig)e.getValue()).minimum().orElse(Integer.MIN_VALUE).intValue()).build()).collect(Collectors.toList());
        LinkedList<Map<Object, Object>> allResources = new LinkedList<Map<Object, Object>>();
        for (Map.Entry<String, byte[]> generatedFile : generatedFiles.entrySet()) {
            String valueReferenceProperty;
            if (!generatedFile.getKey().toLowerCase().matches(YAML_REG_EXP)) continue;
            YamlExpressionParser parser = YamlPath.from((InputStream[])new InputStream[]{new ByteArrayInputStream(generatedFile.getValue())});
            HashMap<String, Object> seen = new HashMap<String, Object>();
            HashSet<String> paths = new HashSet<String>();
            ArrayList<Object> valuesReferences = new ArrayList<Object>();
            valuesReferences.addAll(valuesReferencesFromUser);
            valuesReferences.addAll(valuesReferencesFromDecorators);
            for (ConfigReference configReference : valuesReferences) {
                if (this.valueIsEnvironmentProperty(configReference)) continue;
                valueReferenceProperty = HelmConfigUtils.deductProperty(helmConfig, configReference.getProperty());
                this.processValueReference(valueReferenceProperty, configReference.getValue(), configReference, values, parser, seen, paths, "");
            }
            for (ConfigReference configReference : valuesReferences) {
                if (!this.valueIsEnvironmentProperty(configReference)) continue;
                valueReferenceProperty = HelmConfigUtils.deductProperty(helmConfig, configReference.getProperty());
                Object valueReferenceValue = configReference.getValue();
                String environmentProperty = this.getEnvironmentPropertyName(configReference);
                Map<String, ValuesHolder.HelmValueHolder> current = values.get(configReference.getProfile());
                for (Map.Entry<String, ValuesHolder.HelmValueHolder> currentValue : current.entrySet()) {
                    if (!currentValue.getKey().endsWith(environmentProperty)) continue;
                    valueReferenceProperty = currentValue.getKey();
                    valueReferenceValue = currentValue.getValue().value;
                    break;
                }
                this.processValueReference(valueReferenceProperty, valueReferenceValue, configReference, values, parser, seen, paths, " | quote");
            }
            allResources.addAll(parser.getResources());
        }
        return allResources;
    }

    private boolean valueIsEnvironmentProperty(ConfigReference valueReference) {
        return valueReference.getProperty().contains(ENVIRONMENT_PROPERTY_GROUP);
    }

    private String getEnvironmentPropertyName(ConfigReference valueReference) {
        String property = valueReference.getProperty();
        int index = valueReference.getProperty().indexOf(ENVIRONMENT_PROPERTY_GROUP);
        if (index >= 0) {
            property = property.substring(index + ENVIRONMENT_PROPERTY_GROUP.length());
        }
        return property;
    }

    private void processValueReference(String property, Object value, ConfigReference valueReference, ValuesHolder values, YamlExpressionParser parser, Map<String, Object> seen, Set<String> paths, String defaultConversion) {
        String profile = valueReference.getProfile();
        if (valueReference.getPaths() != null && valueReference.getPaths().length > 0) {
            for (String path : valueReference.getPaths()) {
                Object actualValue;
                Object found = seen.get(property);
                if (paths.contains(path) && found != null) continue;
                if (found == null) {
                    found = YamlExpressionParserUtils.read(parser, path);
                    paths.add(path);
                }
                if ((actualValue = Optional.ofNullable(value).orElse(found)) == null) continue;
                YamlExpressionParserUtils.set(parser, path, YamlExpressionParserUtils.toExpression(property, value, found, valueReference, defaultConversion));
                values.putIfAbsent(property, valueReference, actualValue, profile);
                if (!StringUtils.isEmpty((CharSequence)profile)) continue;
                seen.putIfAbsent(property, actualValue);
            }
        } else {
            values.putIfAbsent(property, valueReference, value, profile);
            if (StringUtils.isEmpty((CharSequence)profile)) {
                seen.putIfAbsent(property, value);
            }
        }
    }

    private Map<String, String> createChartYaml(String name, HelmChartConfig helmConfig, Project project, Path inputDir, Path outputDir) throws IOException {
        Chart chart = new Chart();
        chart.setName(name);
        chart.setVersion(this.getVersion(helmConfig, project));
        helmConfig.description().ifPresent(arg_0 -> ((Chart)chart).setDescription(arg_0));
        helmConfig.home().ifPresent(arg_0 -> ((Chart)chart).setHome(arg_0));
        helmConfig.sources().ifPresent(arg_0 -> ((Chart)chart).setSources(arg_0));
        chart.setMaintainers(helmConfig.maintainers().entrySet().stream().map(e -> new Maintainer(((MaintainerConfig)e.getValue()).name().orElse((String)e.getKey()), ((MaintainerConfig)e.getValue()).email().orElse(""), ((MaintainerConfig)e.getValue()).url().orElse(""))).collect(Collectors.toList()));
        helmConfig.icon().ifPresent(arg_0 -> ((Chart)chart).setIcon(arg_0));
        chart.setApiVersion(helmConfig.apiVersion());
        helmConfig.condition().ifPresent(arg_0 -> ((Chart)chart).setCondition(arg_0));
        helmConfig.tags().ifPresent(arg_0 -> ((Chart)chart).setTags(arg_0));
        helmConfig.appVersion().ifPresent(arg_0 -> ((Chart)chart).setAppVersion(arg_0));
        helmConfig.deprecated().ifPresent(arg_0 -> ((Chart)chart).setDeprecated(arg_0));
        chart.setAnnotations(helmConfig.annotations());
        helmConfig.kubeVersion().ifPresent(arg_0 -> ((Chart)chart).setKubeVersion(arg_0));
        helmConfig.keywords().ifPresent(arg_0 -> ((Chart)chart).setKeywords(arg_0));
        chart.setDependencies(helmConfig.dependencies().entrySet().stream().map(d -> new HelmDependency(((HelmDependencyConfig)d.getValue()).name().orElse((String)d.getKey()), ((HelmDependencyConfig)d.getValue()).alias().orElse(((HelmDependencyConfig)d.getValue()).name().orElse((String)d.getKey())), ((HelmDependencyConfig)d.getValue()).version(), ((HelmDependencyConfig)d.getValue()).repository(), ((HelmDependencyConfig)d.getValue()).condition().orElse(""), ((HelmDependencyConfig)d.getValue()).tags().map(l -> l.toArray(new String[0])).orElse(new String[0]), ((HelmDependencyConfig)d.getValue()).enabled().orElse(true))).collect(Collectors.toList()));
        helmConfig.type().ifPresent(arg_0 -> ((Chart)chart).setType(arg_0));
        Path yml = this.getChartOutputDir(name, outputDir).resolve(CHART_FILENAME).normalize();
        File userChartFile = inputDir.resolve(CHART_FILENAME).toFile();
        Object chartContent = chart;
        if (userChartFile.exists()) {
            chartContent = this.mergeWithFileIfExists(inputDir, CHART_FILENAME, MapUtils.toMultiValueUnsortedMap((Map)Serialization.yamlMapper().readValue(Serialization.asYaml((Object)chart), Map.class)));
        }
        return this.writeFileAsYaml(chartContent, yml);
    }

    private Map<String, String> writeFileAsYaml(Object data, Path file) throws IOException {
        String value = Serialization.asYaml((Object)data);
        return this.writeFile(QuarkusHelmWriterSessionListener.applyKnownPatterns(value), file);
    }

    private Map<String, String> writeFileAsJson(Object data, Path file) throws IOException {
        String value = Serialization.asJson((Object)data);
        return this.writeFile(QuarkusHelmWriterSessionListener.applyKnownPatterns(value), file);
    }

    private Map<String, String> writeFile(String value, Path file) throws IOException {
        try (FileWriter writer = new FileWriter(file.toFile(), true);){
            writer.write(value);
            Map<String, String> map = Collections.singletonMap(file.toString(), value);
            return map;
        }
    }

    private Path getChartOutputDir(String name, Path outputDir) {
        return outputDir.resolve(name);
    }

    private Object toValue(ValueReferenceConfig v) {
        if (v.valueAsInt().isPresent()) {
            return v.valueAsInt().get();
        }
        if (v.valueAsBool().isPresent()) {
            return v.valueAsBool().get();
        }
        if (!v.valueAsMap().isEmpty()) {
            return v.valueAsMap();
        }
        if (v.valueAsList().isPresent()) {
            return v.valueAsList().get();
        }
        return v.value().orElse(null);
    }

    private static String applyKnownPatterns(String adaptedString) {
        adaptedString = adaptedString.replaceAll(Pattern.quote("\"{{"), "{{").replaceAll(Pattern.quote("}}\""), "}}").replaceAll("\":START:", "").replaceAll(":END:\"", "").replaceAll(":DOUBLE_QUOTES", "\"").replaceAll(":LINE_SEPARATOR:", System.lineSeparator()).replaceAll("\\\\\\n(\\s)*\\\\", "");
        return adaptedString;
    }
}

