/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.helm.spi;

import io.quarkiverse.helm.model.Chart;
import io.quarkiverse.helm.model.ValuesSchema;
import io.quarkus.builder.item.MultiBuildItem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class HelmChartBuildItem
extends MultiBuildItem {
    private final String deploymentTarget;
    private final Chart chart;
    private final ValuesSchema valuesSchema;
    private final Map<String, Map<String, Object>> values;
    private final Map<String, String> templates;
    private final Optional<String> notes;
    private final Optional<String> readme;

    public HelmChartBuildItem(String deploymentTarget, Chart chart, ValuesSchema valuesSchema, Map<String, Map<String, Object>> values, Map<String, String> templates, Optional<String> notes, Optional<String> readme) {
        this.deploymentTarget = deploymentTarget;
        this.chart = chart;
        this.valuesSchema = valuesSchema;
        this.values = values;
        this.templates = templates;
        this.notes = notes;
        this.readme = readme;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HelmChartBuildItem read(Path dir, Function<String, Object> deserializer) {
        try {
            Path chartYamlPath = dir.resolve("Chart.yaml");
            Path valuesYamlPath = dir.resolve("values.yaml");
            Path valuesSchemaPath = dir.resolve("values.schema.json");
            Path templatesDir = dir.resolve("templates");
            Path notesPath = templatesDir.resolve("NOTES.txt");
            Path readmePath = dir.resolve("README.md");
            Chart chart = (Chart)deserializer.apply(Files.readString(chartYamlPath));
            Map values = (Map)deserializer.apply(Files.readString(valuesYamlPath));
            ValuesSchema valuesSchema = (ValuesSchema)deserializer.apply(Files.readString(valuesSchemaPath));
            HashMap<String, String> templates = new HashMap<String, String>();
            if (Files.isDirectory(templatesDir, new LinkOption[0])) {
                Files.list(templatesDir).forEach(templatePath -> {
                    try {
                        if (!Files.isDirectory(templatePath, new LinkOption[0])) {
                            templates.put(templatePath.getFileName().toString(), Files.readString(templatePath));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            Optional<String> notes = Files.exists(notesPath, new LinkOption[0]) ? Optional.of(Files.readString(notesPath)) : Optional.empty();
            Optional<String> readme = Files.exists(readmePath, new LinkOption[0]) ? Optional.of(Files.readString(readmePath)) : Optional.empty();
            return HelmChartBuildItem.builder().withChart(chart).withValues(values).withValuesSchema(valuesSchema).withTemplates(templates).withNotes(notes).withReadme(readme).build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read HelmChartBuildItem from file system", e);
        }
    }

    public void write(Path dir, Function<Object, String> serializer) {
        Path targetDir = dir.resolve(this.deploymentTarget);
        Path chartDir = targetDir.resolve(this.getName());
        Path chartYamlPath = chartDir.resolve("Chart.yaml");
        Path valuesYamlPath = chartDir.resolve("values.yaml");
        Path valuesSchemaPath = chartDir.resolve("values.schema.json");
        Path templatesDir = chartDir.resolve("templates");
        Path notesPath = templatesDir.resolve("NOTES.txt");
        Path readmePath = chartDir.resolve("README.md");
        try {
            if (!Files.exists(templatesDir, new LinkOption[0])) {
                Files.createDirectories(templatesDir, new FileAttribute[0]);
            }
            Files.write(chartYamlPath, serializer.apply(this.chart).getBytes(), new OpenOption[0]);
            Files.write(valuesYamlPath, serializer.apply(this.values).getBytes(), new OpenOption[0]);
            Files.write(valuesSchemaPath, serializer.apply(this.valuesSchema).getBytes(), new OpenOption[0]);
            Files.write(notesPath, serializer.apply(this.notes).getBytes(), new OpenOption[0]);
            this.readme.ifPresent(r -> {
                try {
                    Files.write(readmePath, ((String)serializer.apply(r)).getBytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            Files.write(readmePath, serializer.apply(this.readme).getBytes(), new OpenOption[0]);
            for (Map.Entry<String, String> entry : this.templates.entrySet()) {
                String templateFileName = entry.getKey();
                String templateContent = entry.getValue();
                Path templatePath = templatesDir.resolve(templateFileName);
                Files.write(templatePath, serializer.apply(templateContent).getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.chart.getName();
    }

    public String getDeploymentTarget() {
        return this.deploymentTarget;
    }

    public Chart getChart() {
        return this.chart;
    }

    public ValuesSchema getValuesSchema() {
        return this.valuesSchema;
    }

    public Map<String, Map<String, Object>> getValues() {
        return this.values;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public Optional<String> getNotes() {
        return this.notes;
    }

    public Optional<String> getReadme() {
        return this.readme;
    }

    public static class Builder {
        private String deploymentTarget;
        private Chart chart;
        private ValuesSchema valuesSchema;
        private Map<String, Map<String, Object>> values;
        private Map<String, String> templates;
        private Optional<String> notes;
        private Optional<String> readme;

        public Builder withDeploymentTarget(String deploymentTarget) {
            this.deploymentTarget = deploymentTarget;
            return this;
        }

        public Builder withChart(Chart chart) {
            this.chart = chart;
            return this;
        }

        public Builder withValuesSchema(ValuesSchema valuesSchema) {
            this.valuesSchema = valuesSchema;
            return this;
        }

        public Builder withValues(Map<String, Map<String, Object>> values) {
            this.values = values;
            return this;
        }

        public Builder withTemplates(Map<String, String> templates) {
            this.templates = templates;
            return this;
        }

        public Builder withNotes(Optional<String> notes) {
            this.notes = notes;
            return this;
        }

        public Builder withReadme(Optional<String> readme) {
            this.readme = readme;
            return this;
        }

        public HelmChartBuildItem build() {
            return new HelmChartBuildItem(this.deploymentTarget, this.chart, this.valuesSchema, this.values, this.templates, this.notes, this.readme);
        }
    }
}

